/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.client;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketReceiveEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3i;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientUpdateSign
extends PacketWrapper<WrapperPlayClientUpdateSign> {
    private Vector3i blockPosition;
    private String[] textLines;

    public WrapperPlayClientUpdateSign(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientUpdateSign(Vector3i blockPosition, String[] textLines) {
        super(PacketType.Play.Client.UPDATE_SIGN);
        this.blockPosition = blockPosition;
        this.textLines = textLines;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.blockPosition = new Vector3i(this.readLong());
        } else {
            int x = this.readInt();
            short y = this.readShort();
            int z = this.readInt();
            this.blockPosition = new Vector3i(x, y, z);
        }
        this.textLines = new String[4];
        for (int i = 0; i < 4; ++i) {
            this.textLines[i] = this.readString(384);
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            long positionVector = this.blockPosition.getSerializedPosition();
            this.writeLong(positionVector);
        } else {
            this.writeInt(this.blockPosition.x);
            this.writeShort(this.blockPosition.y);
            this.writeInt(this.blockPosition.z);
        }
        for (int i = 0; i < 4; ++i) {
            this.writeString(this.textLines[i], 384);
        }
    }

    @Override
    public void copy(WrapperPlayClientUpdateSign wrapper) {
        this.blockPosition = wrapper.blockPosition;
        this.textLines = wrapper.textLines;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setTextLines(String[] textLines) {
        this.textLines = textLines;
    }
}

