/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Location;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.MathUtil;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.Vector3d;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerEntityTeleport
extends PacketWrapper<WrapperPlayServerEntityTeleport> {
    private static final float ROTATION_FACTOR = 0.7111111f;
    private int entityID;
    private Vector3d position;
    private float yaw;
    private float pitch;
    private boolean onGround;

    public WrapperPlayServerEntityTeleport(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityTeleport(int entityID, Location location, boolean onGround) {
        this(entityID, location.getPosition(), location.getYaw(), location.getPitch(), onGround);
    }

    public WrapperPlayServerEntityTeleport(int entityID, Vector3d position, float yaw, float pitch, boolean onGround) {
        super(PacketType.Play.Server.ENTITY_TELEPORT);
        this.entityID = entityID;
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
        this.onGround = onGround;
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion == ServerVersion.V_1_7_10 ? this.readInt() : this.readVarInt();
        this.position = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_8_8) ? new Vector3d((double)this.readInt() / 32.0, (double)this.readInt() / 32.0, (double)this.readInt() / 32.0) : new Vector3d(this.readDouble(), this.readDouble(), this.readDouble());
        this.yaw = (float)this.readByte() / 0.7111111f;
        this.pitch = (float)this.readByte() / 0.7111111f;
        this.onGround = this.serverVersion != ServerVersion.V_1_7_10 ? this.readBoolean() : false;
    }

    @Override
    public void write() {
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_8_8)) {
            this.writeInt(MathUtil.floor(this.position.x * 32.0));
            this.writeInt(MathUtil.floor(this.position.y * 32.0));
            this.writeInt(MathUtil.floor(this.position.z * 32.0));
        } else {
            this.writeDouble(this.position.x);
            this.writeDouble(this.position.y);
            this.writeDouble(this.position.z);
        }
        this.writeByte((int)(this.yaw * 0.7111111f));
        this.writeByte((int)(this.pitch * 0.7111111f));
        if (this.serverVersion != ServerVersion.V_1_7_10) {
            this.writeBoolean(this.onGround);
        }
    }

    @Override
    public void copy(WrapperPlayServerEntityTeleport wrapper) {
        this.entityID = wrapper.entityID;
        this.position = wrapper.position;
        this.yaw = wrapper.yaw;
        this.pitch = wrapper.pitch;
        this.onGround = wrapper.onGround;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }
}

