/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;

public class WrapperPlayServerOpenWindow
extends PacketWrapper<WrapperPlayServerOpenWindow> {
    private int containerId;
    private int type;
    private String legacyType;
    private int legacySlots;
    private int horseId;
    private String title;
    private Component titleAsComponent = null;
    private boolean useProvidedWindowTitle;

    public WrapperPlayServerOpenWindow(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerOpenWindow(int containerId, int type, Component title) {
        super(PacketType.Play.Server.OPEN_WINDOW);
        this.containerId = containerId;
        this.type = type;
        this.title = AdventureSerializer.toJson(title);
    }

    public WrapperPlayServerOpenWindow(int containerId, String legacyType, Component title, int legacySlots, int horseId) {
        super(PacketType.Play.Server.OPEN_WINDOW);
        this.containerId = containerId;
        this.legacyType = legacyType;
        this.legacySlots = legacySlots;
        this.horseId = horseId;
        this.title = AdventureSerializer.toJson(title);
    }

    public WrapperPlayServerOpenWindow(int containerId, int type, Component title, int legacySlots, boolean useProvidedWindowTitle, int horseId) {
        super(PacketType.Play.Server.OPEN_WINDOW);
        this.containerId = containerId;
        this.type = type;
        this.title = AdventureSerializer.toJson(title);
        this.legacySlots = legacySlots;
        this.useProvidedWindowTitle = useProvidedWindowTitle;
        this.horseId = horseId;
    }

    @Override
    public void read() {
        this.containerId = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_13_2) ? (int)this.readUnsignedByte() : this.readVarInt();
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.type = this.readUnsignedByte();
            this.title = this.readString(32);
            this.legacySlots = this.readUnsignedByte();
            this.useProvidedWindowTitle = this.readBoolean();
            if (this.type == 11) {
                this.horseId = this.readInt();
            }
            return;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.type = this.readVarInt();
            this.title = this.readComponentJSON();
        } else {
            this.legacyType = this.readString();
            this.title = this.readComponentJSON();
            this.legacySlots = this.readUnsignedByte();
            if (this.legacyType.equals("EntityHorse")) {
                this.horseId = this.readInt();
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_13_2)) {
            this.writeByte(this.containerId);
        } else {
            this.writeVarInt(this.containerId);
        }
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeByte(this.type);
            this.writeString(this.title);
            this.writeByte(this.legacySlots);
            this.writeBoolean(this.useProvidedWindowTitle);
            if (this.type == 11) {
                this.writeInt(this.horseId);
            }
            return;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.writeVarInt(this.type);
            if (this.titleAsComponent != null) {
                this.writeComponent(this.titleAsComponent);
            } else {
                this.writeString(this.title);
            }
        } else {
            this.writeString(this.legacyType);
            if (this.titleAsComponent != null) {
                this.writeComponent(this.titleAsComponent);
            } else {
                this.writeString(this.title);
            }
            this.writeByte(this.legacySlots);
            if (this.legacyType.equals("EntityHorse")) {
                this.writeInt(this.horseId);
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerOpenWindow wrapper) {
        this.containerId = wrapper.containerId;
        this.type = wrapper.type;
        this.legacyType = wrapper.legacyType;
        this.legacySlots = wrapper.legacySlots;
        this.horseId = wrapper.horseId;
        this.title = wrapper.title;
        this.titleAsComponent = wrapper.titleAsComponent;
        this.useProvidedWindowTitle = wrapper.useProvidedWindowTitle;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public void setContainerId(int containerId) {
        this.containerId = containerId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLegacyType() {
        return this.legacyType;
    }

    public void setLegacyType(String legacyType) {
        this.legacyType = legacyType;
    }

    public int getLegacySlots() {
        return this.legacySlots;
    }

    public void setLegacySlots(int legacySlots) {
        this.legacySlots = legacySlots;
    }

    public int getHorseId() {
        return this.horseId;
    }

    public void setHorseId(int horseId) {
        this.horseId = horseId;
    }

    public Component getTitle() {
        if (this.titleAsComponent != null) {
            return this.titleAsComponent;
        }
        this.titleAsComponent = AdventureSerializer.parseComponent(this.title);
        return this.titleAsComponent;
    }

    public void setTitle(Component title) {
        this.titleAsComponent = title;
    }

    public boolean isUseProvidedWindowTitle() {
        return this.useProvidedWindowTitle;
    }

    public void setUseProvidedWindowTitle(boolean useProvidedWindowTitle) {
        this.useProvidedWindowTitle = useProvidedWindowTitle;
    }
}

