/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerResourcePackSend
extends PacketWrapper<WrapperPlayServerResourcePackSend> {
    public static final int MAX_HASH_LENGTH = 40;
    private String url;
    private String hash;
    private boolean required;
    private Component prompt;

    public WrapperPlayServerResourcePackSend(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerResourcePackSend(String url, String hash, boolean required, @Nullable Component prompt) {
        super(PacketType.Play.Server.RESOURCE_PACK_SEND);
        if (hash.length() > 40) {
            throw new IllegalArgumentException("Hash is too long (max 40, was " + hash.length() + ")");
        }
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.prompt = prompt;
    }

    @Override
    public void read() {
        this.url = this.readString();
        this.hash = this.readString(40);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            this.required = this.readBoolean();
            boolean hasPrompt = this.readBoolean();
            if (hasPrompt) {
                this.prompt = this.readComponent();
            }
        }
    }

    @Override
    public void write() {
        this.writeString(this.url);
        this.writeString(this.hash, 40);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            this.writeBoolean(this.required);
            this.writeBoolean(this.prompt != null);
            if (this.prompt != null) {
                this.writeComponent(this.prompt);
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerResourcePackSend wrapper) {
        this.url = wrapper.url;
        this.hash = wrapper.hash;
        this.required = wrapper.required;
        this.prompt = wrapper.prompt;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Component getPrompt() {
        return this.prompt;
    }
}

