/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.GameMode;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Difficulty;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.Dimension;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.DimensionType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.WorldBlockPosition;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.world.WorldType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.resources.ResourceLocation;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerRespawn
extends PacketWrapper<WrapperPlayServerRespawn> {
    private Dimension dimension;
    private Optional<String> worldName;
    private Difficulty difficulty;
    private long hashedSeed;
    private GameMode gameMode;
    @Nullable
    private GameMode previousGameMode;
    private boolean worldDebug;
    private boolean worldFlat;
    private boolean keepingAllPlayerData;
    private WorldBlockPosition lastDeathPosition;
    private String levelType;

    public WrapperPlayServerRespawn(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerRespawn(Dimension dimension, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, boolean keepingAllPlayerData, @Nullable ResourceLocation deathDimensionName, @Nullable WorldBlockPosition lastDeathPosition) {
        super(PacketType.Play.Server.RESPAWN);
        this.dimension = dimension;
        this.setWorldName(worldName);
        this.difficulty = difficulty;
        this.hashedSeed = hashedSeed;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.worldDebug = worldDebug;
        this.worldFlat = worldFlat;
        this.keepingAllPlayerData = keepingAllPlayerData;
        this.lastDeathPosition = lastDeathPosition;
    }

    @Override
    public void read() {
        boolean v1_14 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14);
        boolean v1_15_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15);
        boolean v1_16_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16);
        boolean v1_19 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        if (v1_16_0) {
            this.dimension = this.readDimension();
            this.worldName = Optional.of(this.readString());
            this.hashedSeed = this.readLong();
            this.gameMode = GameMode.getById(this.readUnsignedByte());
            byte previousMode = this.readByte();
            this.previousGameMode = previousMode == -1 ? null : GameMode.getById(previousMode);
            this.worldDebug = this.readBoolean();
            this.worldFlat = this.readBoolean();
            this.keepingAllPlayerData = this.readBoolean();
            if (v1_19) {
                this.lastDeathPosition = (WorldBlockPosition)this.readOptional(PacketWrapper::readWorldBlockPosition);
            }
        } else {
            this.dimension = new Dimension(this.readInt());
            this.worldName = Optional.empty();
            this.hashedSeed = 0L;
            if (v1_15_0) {
                this.hashedSeed = this.readLong();
            } else if (!v1_14) {
                this.difficulty = Difficulty.getById(this.readByte());
            }
            this.gameMode = GameMode.getById(this.readByte());
            this.levelType = this.readString(16);
            this.worldFlat = DimensionType.isFlat(this.levelType);
            this.worldDebug = DimensionType.isDebug(this.levelType);
        }
    }

    @Override
    public void write() {
        boolean v1_14 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14);
        boolean v1_15_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15);
        boolean v1_16_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16);
        boolean v1_19 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        if (v1_16_0) {
            this.writeDimension(this.dimension);
            this.writeString(this.worldName.orElse(""));
            this.writeLong(this.hashedSeed);
            this.writeByte(this.gameMode.ordinal());
            this.writeByte(this.previousGameMode == null ? -1 : this.previousGameMode.ordinal());
            this.writeBoolean(this.worldDebug);
            this.writeBoolean(this.worldFlat);
            this.writeBoolean(this.keepingAllPlayerData);
            if (v1_19) {
                this.writeOptional(this.lastDeathPosition, PacketWrapper::writeWorldBlockPosition);
            }
        } else {
            this.writeInt(this.dimension.getId());
            if (v1_15_0) {
                this.writeLong(this.hashedSeed);
            } else if (!v1_14) {
                int id = this.difficulty == null ? Difficulty.NORMAL.getId() : this.difficulty.getId();
                this.writeByte(id);
            }
            this.writeByte(this.gameMode.ordinal());
            if (this.worldFlat) {
                this.writeString(WorldType.FLAT.getName());
            } else if (this.worldDebug) {
                this.writeString(WorldType.DEBUG_ALL_BLOCK_STATES.getName());
            } else {
                this.writeString(this.levelType == null ? WorldType.DEFAULT.getName() : this.levelType, 16);
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerRespawn wrapper) {
        this.dimension = wrapper.dimension;
        this.worldName = wrapper.worldName;
        this.difficulty = wrapper.difficulty;
        this.hashedSeed = wrapper.hashedSeed;
        this.gameMode = wrapper.gameMode;
        this.previousGameMode = wrapper.previousGameMode;
        this.worldDebug = wrapper.worldDebug;
        this.worldFlat = wrapper.worldFlat;
        this.keepingAllPlayerData = wrapper.keepingAllPlayerData;
        this.lastDeathPosition = wrapper.lastDeathPosition;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Optional<String> getWorldName() {
        return this.worldName;
    }

    public void setWorldName(@Nullable String worldName) {
        this.worldName = Optional.ofNullable(worldName);
    }

    @Nullable
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    public void setHashedSeed(long hashedSeed) {
        this.hashedSeed = hashedSeed;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    @Nullable
    public GameMode getPreviousGameMode() {
        return this.previousGameMode;
    }

    public void setPreviousGameMode(@Nullable GameMode previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    public boolean isWorldDebug() {
        return this.worldDebug;
    }

    public void setWorldDebug(boolean worldDebug) {
        this.worldDebug = worldDebug;
    }

    public boolean isWorldFlat() {
        return this.worldFlat;
    }

    public void setWorldFlat(boolean worldFlat) {
        this.worldFlat = worldFlat;
    }

    public boolean isKeepingAllPlayerData() {
        return this.keepingAllPlayerData;
    }

    public void setKeepingAllPlayerData(boolean keepAllPlayerData) {
        this.keepingAllPlayerData = keepAllPlayerData;
    }

    @Nullable
    public WorldBlockPosition getLastDeathPosition() {
        return this.lastDeathPosition;
    }

    public void setLastDeathPosition(@Nullable WorldBlockPosition lastDeathPosition) {
        this.lastDeathPosition = lastDeathPosition;
    }
}

