/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.play.server;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerVersion;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.ChatType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.chat.ChatTypes;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.AdventureSerializer;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerSystemChatMessage
extends PacketWrapper<WrapperPlayServerSystemChatMessage> {
    public static boolean HANDLE_JSON = true;
    @Nullable
    private ChatType type;
    private boolean overlay;
    private String messageJson;
    private Component message;

    public WrapperPlayServerSystemChatMessage(PacketSendEvent event) {
        super(event);
    }

    @Deprecated
    public WrapperPlayServerSystemChatMessage(@NotNull ChatType type, Component message) {
        super(PacketType.Play.Server.SYSTEM_CHAT_MESSAGE);
        this.type = type;
        if (type == ChatTypes.GAME_INFO) {
            this.overlay = true;
        }
        this.message = message;
    }

    @Deprecated
    public WrapperPlayServerSystemChatMessage(@NotNull ChatType type, String messageJson) {
        super(PacketType.Play.Server.SYSTEM_CHAT_MESSAGE);
        this.messageJson = messageJson;
        this.type = type;
        if (type == ChatTypes.GAME_INFO) {
            this.overlay = true;
        }
    }

    public WrapperPlayServerSystemChatMessage(boolean overlay, Component message) {
        super(PacketType.Play.Server.SYSTEM_CHAT_MESSAGE);
        this.message = message;
        this.overlay = overlay;
        this.type = overlay ? ChatTypes.GAME_INFO : ChatTypes.SYSTEM;
    }

    @Deprecated
    public WrapperPlayServerSystemChatMessage(boolean overlay, String messageJson) {
        super(PacketType.Play.Server.SYSTEM_CHAT_MESSAGE);
        this.messageJson = messageJson;
        this.overlay = overlay;
        this.type = overlay ? ChatTypes.GAME_INFO : ChatTypes.SYSTEM;
    }

    @Override
    public void read() {
        this.messageJson = this.readComponentJSON();
        if (HANDLE_JSON) {
            this.message = AdventureSerializer.parseComponent(this.messageJson);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1)) {
            this.overlay = this.readBoolean();
        } else {
            this.type = ChatTypes.getById(this.serverVersion.toClientVersion(), this.readVarInt());
        }
    }

    @Override
    public void write() {
        if (HANDLE_JSON && this.message != null) {
            this.messageJson = AdventureSerializer.toJson(this.message);
        }
        this.writeComponentJSON(this.messageJson);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1)) {
            this.writeBoolean(this.overlay);
        } else if (this.type == null) {
            if (this.overlay) {
                this.writeVarInt(ChatTypes.GAME_INFO.getId(this.serverVersion.toClientVersion()));
            } else {
                this.writeVarInt(ChatTypes.SYSTEM.getId(this.serverVersion.toClientVersion()));
            }
        } else {
            this.writeVarInt(this.type.getId(this.serverVersion.toClientVersion()));
        }
    }

    @Override
    public void copy(WrapperPlayServerSystemChatMessage wrapper) {
        this.type = wrapper.type;
        this.overlay = wrapper.overlay;
        this.messageJson = wrapper.messageJson;
        this.message = wrapper.message;
    }

    @Deprecated
    @Nullable
    public ChatType getType() {
        return this.type;
    }

    @Deprecated
    public void setType(@Nullable ChatType type) {
        this.type = type;
    }

    public String getMessageJson() {
        return this.messageJson;
    }

    public void setMessageJson(String messageJson) {
        this.messageJson = messageJson;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }
}

