/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.factory.spigot;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEventsAPI;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.injector.ChannelInjector;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.player.PlayerManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.protocol.ProtocolManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.manager.server.ServerManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.NettyManager;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.packettype.PacketType;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.User;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.settings.PacketEventsSettings;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.LogManager;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.bstats.Metrics;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.bukkit.InternalBukkitListener;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.SpigotChannelInjector;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.connection.ServerConnectionInitializer;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.manager.InternalBukkitPacketListener;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.manager.player.PlayerManagerImpl;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.manager.protocol.ProtocolManagerImpl;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.manager.server.ServerManagerImpl;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.netty.NettyManagerImpl;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.BukkitLogManager;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.FoliaCompatUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.SpigotReflectionUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.protocolsupport.ProtocolSupportUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.viaversion.CustomPipelineUtil;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.viaversion.ViaVersionUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPacketEventsBuilder {
    private static PacketEventsAPI<Plugin> API_INSTANCE;

    public static void clearBuildCache() {
        API_INSTANCE = null;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpigotPacketEventsBuilder.buildNoCache(plugin);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin, PacketEventsSettings settings) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpigotPacketEventsBuilder.buildNoCache(plugin, settings);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<Plugin> buildNoCache(Plugin plugin) {
        return SpigotPacketEventsBuilder.buildNoCache(plugin, new PacketEventsSettings());
    }

    public static PacketEventsAPI<Plugin> buildNoCache(final Plugin plugin, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<Plugin>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManager playerManager;
            private final NettyManager nettyManager;
            private final SpigotChannelInjector injector;
            private final LogManager logManager;
            private final AtomicBoolean loaded;
            private final AtomicBoolean initialized;
            private boolean lateBind;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerImpl();
                this.serverManager = new ServerManagerImpl();
                this.playerManager = new PlayerManagerImpl();
                this.nettyManager = new NettyManagerImpl();
                this.injector = new SpigotChannelInjector();
                this.logManager = new BukkitLogManager();
                this.loaded = new AtomicBoolean(false);
                this.initialized = new AtomicBoolean(false);
                this.lateBind = false;
            }

            @Override
            public void load() {
                if (!this.loaded.getAndSet(true)) {
                    String id = plugin.getName().toLowerCase();
                    PacketEvents.IDENTIFIER = "pe-" + id;
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                    PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                    try {
                        SpigotReflectionUtil.init();
                        CustomPipelineUtil.init();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException(ex);
                    }
                    if (!PacketType.isPrepared()) {
                        PacketType.prepare();
                    }
                    boolean bl = this.lateBind = !this.injector.isServerBound();
                    if (!this.lateBind) {
                        this.injector.inject();
                    }
                    this.getEventManager().registerListener(new InternalBukkitPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded.get();
            }

            @Override
            public void init() {
                this.load();
                if (!this.initialized.getAndSet(true)) {
                    if (this.settings.shouldCheckForUpdates()) {
                        this.getUpdateChecker().handleUpdateCheck();
                    }
                    if (this.settings.isbStatsEnabled()) {
                        Metrics metrics = new Metrics((JavaPlugin)plugin, 11327);
                        metrics.addCustomChart(new Metrics.SimplePie("packetevents_version", () -> this.getVersion().toString() + "-beta"));
                    }
                    Bukkit.getPluginManager().registerEvents((Listener)new InternalBukkitListener(plugin), plugin);
                    if (this.lateBind) {
                        Runnable lateBindTask = () -> {
                            if (this.injector.isServerBound()) {
                                this.injector.inject();
                            }
                        };
                        FoliaCompatUtil.runTaskOnInit(plugin, lateBindTask);
                    }
                    if (!"true".equalsIgnoreCase(System.getenv("PE_IGNORE_INCOMPATIBILITY"))) {
                        this.checkCompatibility();
                    }
                }
            }

            private void checkCompatibility() {
                int majorVersion;
                Plugin protocolLibPlugin;
                ViaVersionUtil.checkIfViaIsPresent();
                ProtocolSupportUtil.checkIfProtocolSupportIsPresent();
                Plugin viaPlugin = Bukkit.getPluginManager().getPlugin("ViaVersion");
                if (viaPlugin != null) {
                    String[] ver = viaPlugin.getDescription().getVersion().split("\\.", 3);
                    int major = Integer.parseInt(ver[0]);
                    int minor = Integer.parseInt(ver[1]);
                    if (major < 4 || major == 4 && minor < 5) {
                        PacketEvents.getAPI().getLogManager().severe("You are attempting to combine 2.0 PacketEvents with a ViaVersion older than 4.5.0, please update your ViaVersion!");
                        Plugin ourPlugin = this.getPlugin();
                        Bukkit.getPluginManager().disablePlugin(ourPlugin);
                        throw new IllegalStateException("ViaVersion incompatibility! Update to v4.5.0 or newer!");
                    }
                }
                if ((protocolLibPlugin = Bukkit.getPluginManager().getPlugin("ProtocolLib")) != null && (majorVersion = Integer.parseInt(protocolLibPlugin.getDescription().getVersion().split("\\.", 2)[0])) < 5) {
                    PacketEvents.getAPI().getLogManager().severe("You are attempting to combine 2.0 PacketEvents with a ProtocolLib version older than v5.0.0. This is no longer works, please update to their dev builds. https://ci.dmulloy2.net/job/ProtocolLib/lastBuild/");
                    Plugin ourPlugin = this.getPlugin();
                    Bukkit.getPluginManager().disablePlugin(ourPlugin);
                    throw new IllegalStateException("ProtocolLib incompatibility! Update to v5.0.0 or newer!");
                }
            }

            @Override
            public boolean isInitialized() {
                return this.initialized.get();
            }

            @Override
            public void terminate() {
                if (this.initialized.getAndSet(false)) {
                    this.injector.uninject();
                    for (User user : ProtocolManager.USERS.values()) {
                        ServerConnectionInitializer.destroyHandlers(user.getChannel());
                    }
                    this.getEventManager().unregisterAllListeners();
                }
            }

            @Override
            public Plugin getPlugin() {
                return plugin;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }
        };
    }
}

