/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.handlers;

import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.PacketEvents;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.event.PacketSendEvent;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.exception.CancelPacketException;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.exception.InvalidDisconnectPacketSend;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.exception.PacketProcessException;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.netty.buffer.ByteBufHelper;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.ConnectionState;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.protocol.player.User;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.EventCreationUtil;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.util.ExceptionUtil;
import com.github.juliarn.npclib.relocate.com.packetevents.packetevents.wrapper.PacketWrapper;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.connection.ServerConnectionInitializer;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.injector.handlers.PacketEventsDecoder;
import com.github.juliarn.npclib.relocate.io.packetevents.packetevents.util.viaversion.CustomPipelineUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.entity.Player;

public class PacketEventsEncoder
extends MessageToMessageEncoder<ByteBuf> {
    public User user;
    public Player player;
    private boolean handledCompression = COMPRESSION_ENABLED_EVENT != null;
    private ChannelPromise promise;
    public static final Object COMPRESSION_ENABLED_EVENT = PacketEventsEncoder.paperCompressionEnabledEvent();

    public PacketEventsEncoder(User user) {
        this.user = user;
    }

    public PacketEventsEncoder(ChannelHandler encoder) {
        this.user = ((PacketEventsEncoder)encoder).user;
        this.player = ((PacketEventsEncoder)encoder).player;
        this.handledCompression = ((PacketEventsEncoder)encoder).handledCompression;
        this.promise = ((PacketEventsEncoder)encoder).promise;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        boolean needsRecompression = !this.handledCompression && this.handleCompression(ctx, byteBuf);
        this.handleClientBoundPacket(ctx.channel(), this.user, this.player, byteBuf, this.promise);
        if (needsRecompression) {
            this.compress(ctx, byteBuf);
        }
        if (!ByteBufHelper.isReadable(byteBuf)) {
            throw CancelPacketException.INSTANCE;
        }
        list.add(byteBuf.retain());
    }

    private PacketSendEvent handleClientBoundPacket(Channel channel, User user, Object player, ByteBuf buffer, ChannelPromise promise) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketSendEvent packetSendEvent = EventCreationUtil.createSendEvent(channel, user, player, buffer, true);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        PacketEvents.getAPI().getEventManager().callEvent(packetSendEvent, () -> ByteBufHelper.readerIndex(buffer, processIndex));
        if (!packetSendEvent.isCancelled()) {
            PacketWrapper<?> wrapper = packetSendEvent.getLastUsedWrapper();
            if (wrapper != null) {
                ByteBufHelper.clear(buffer);
                int packetId = packetSendEvent.getPacketId();
                packetSendEvent.getLastUsedWrapper().writeVarInt(packetId);
                packetSendEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetSendEvent.hasPostTasks()) {
            for (Runnable task : packetSendEvent.getPostTasks()) {
                task.run();
            }
        }
        if (packetSendEvent.hasTasksAfterSend()) {
            promise.addListener(p -> {
                for (Runnable task : packetSendEvent.getTasksAfterSend()) {
                    task.run();
                }
            });
        }
        return packetSendEvent;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ChannelPromise oldPromise = this.promise != null && !this.promise.isSuccess() ? this.promise : null;
        promise.addListener(p -> {
            this.promise = oldPromise;
        });
        this.promise = promise;
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ExceptionUtil.isException(cause, CancelPacketException.class)) {
            return;
        }
        if (ExceptionUtil.isException(cause, InvalidDisconnectPacketSend.class)) {
            return;
        }
        boolean didWeCauseThis = ExceptionUtil.isException(cause, PacketProcessException.class);
        if (didWeCauseThis && this.user != null && this.user.getConnectionState() != ConnectionState.HANDSHAKING) {
            cause.printStackTrace();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private static Object paperCompressionEnabledEvent() {
        try {
            Class<?> eventClass = Class.forName("io.papermc.paper.network.ConnectionEvent");
            return eventClass.getDeclaredField("COMPRESSION_THRESHOLD_SET").get(null);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(ChannelHandlerContext ctx, ByteBuf input) throws InvocationTargetException {
        ChannelHandler compressor = ctx.pipeline().get("compress");
        ByteBuf temp = ctx.alloc().buffer();
        try {
            if (compressor != null) {
                CustomPipelineUtil.callEncode(compressor, ctx, input, temp);
            }
        }
        finally {
            input.clear().writeBytes(temp);
            temp.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(ChannelHandlerContext ctx, ByteBuf input, ByteBuf output) throws InvocationTargetException {
        ChannelHandler decompressor = ctx.pipeline().get("decompress");
        if (decompressor != null) {
            ByteBuf temp = (ByteBuf)CustomPipelineUtil.callDecode(decompressor, ctx, input).get(0);
            try {
                output.clear().writeBytes(temp);
            }
            finally {
                temp.release();
            }
        }
    }

    private boolean handleCompression(ChannelHandlerContext ctx, ByteBuf buffer) throws InvocationTargetException {
        if (this.handledCompression) {
            return false;
        }
        int compressIndex = ctx.pipeline().names().indexOf("compress");
        if (compressIndex == -1) {
            return false;
        }
        this.handledCompression = true;
        int peEncoderIndex = ctx.pipeline().names().indexOf(PacketEvents.ENCODER_NAME);
        if (peEncoderIndex == -1) {
            return false;
        }
        if (compressIndex > peEncoderIndex) {
            this.decompress(ctx, buffer, buffer);
            PacketEventsDecoder decoder = (PacketEventsDecoder)ctx.pipeline().get(PacketEvents.DECODER_NAME);
            ServerConnectionInitializer.relocateHandlers(ctx.channel(), decoder, this.user);
            return true;
        }
        return false;
    }
}

