/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.manager.protocol;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.github.retrooper.packetevents.protocol.ProtocolVersion;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.PacketTransformationUtil;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;

public interface ProtocolManager {
    public static final Map<UUID, Object> CHANNELS = new ConcurrentHashMap<UUID, Object>();
    public static final Map<Object, User> USERS = new ConcurrentHashMap<Object, User>();

    default public Collection<User> getUsers() {
        return USERS.values();
    }

    default public Collection<Object> getChannels() {
        return CHANNELS.values();
    }

    public ProtocolVersion getPlatformVersion();

    public void sendPacket(Object var1, Object var2);

    public void sendPacketSilently(Object var1, Object var2);

    public void writePacket(Object var1, Object var2);

    public void writePacketSilently(Object var1, Object var2);

    public void receivePacket(Object var1, Object var2);

    public void receivePacketSilently(Object var1, Object var2);

    public ClientVersion getClientVersion(Object var1);

    default public void sendPackets(Object channel, Object ... byteBuf) {
        for (Object buf : byteBuf) {
            this.sendPacket(channel, buf);
        }
    }

    default public void sendPacketsSilently(Object channel, Object ... byteBuf) {
        for (Object buf : byteBuf) {
            this.sendPacketSilently(channel, buf);
        }
    }

    default public void writePackets(Object channel, Object ... byteBuf) {
        for (Object buf : byteBuf) {
            this.writePacket(channel, buf);
        }
    }

    default public void writePacketsSilently(Object channel, Object ... byteBuf) {
        for (Object buf : byteBuf) {
            this.writePacketSilently(channel, buf);
        }
    }

    default public void receivePackets(Object channel, Object ... byteBuf) {
        for (Object buf : byteBuf) {
            this.receivePacket(channel, buf);
        }
    }

    default public void receivePacketsSilently(Object channel, Object ... byteBuf) {
        for (Object buf : byteBuf) {
            this.receivePacketSilently(channel, buf);
        }
    }

    default public void setClientVersion(Object channel, ClientVersion version) {
        this.getUser(channel).setClientVersion(version);
    }

    @ApiStatus.Internal
    default public Object[] transformWrappers(PacketWrapper<?> wrapper, Object channel, boolean outgoing) {
        PacketWrapper<?>[] wrappers = PacketTransformationUtil.transform(wrapper);
        Object[] buffers = new Object[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i].prepareForSend(channel, outgoing);
            buffers[i] = wrappers[i].buffer;
            wrappers[i].buffer = null;
        }
        return buffers;
    }

    default public void sendPacket(Object channel, PacketWrapper<?> wrapper) {
        Object[] transformed = this.transformWrappers(wrapper, channel, true);
        this.sendPackets(channel, transformed);
    }

    default public void sendPacketSilently(Object channel, PacketWrapper<?> wrapper) {
        Object[] transformed = this.transformWrappers(wrapper, channel, true);
        this.sendPacketsSilently(channel, transformed);
    }

    default public void writePacket(Object channel, PacketWrapper<?> wrapper) {
        Object[] transformed = this.transformWrappers(wrapper, channel, true);
        this.writePackets(channel, transformed);
    }

    default public void writePacketSilently(Object channel, PacketWrapper<?> wrapper) {
        Object[] transformed = this.transformWrappers(wrapper, channel, true);
        this.writePacketsSilently(channel, transformed);
    }

    default public void receivePacket(Object channel, PacketWrapper<?> wrapper) {
        Object[] transformed = this.transformWrappers(wrapper, channel, false);
        this.receivePackets(channel, transformed);
    }

    default public void receivePacketSilently(Object channel, PacketWrapper<?> wrapper) {
        Object[] transformed = this.transformWrappers(wrapper, channel, false);
        this.receivePacketsSilently(channel, transformed);
    }

    default public User getUser(Object channel) {
        Object pipeline = ChannelHelper.getPipeline(channel);
        return USERS.get(pipeline);
    }

    default public User removeUser(Object channel) {
        Object pipeline = ChannelHelper.getPipeline(channel);
        return USERS.remove(pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void setUser(Object channel, User user) {
        Object object = channel;
        synchronized (object) {
            Object pipeline = ChannelHelper.getPipeline(channel);
            USERS.put(pipeline, user);
        }
        PacketEvents.getAPI().getInjector().updateUser(channel, user);
    }

    default public Object getChannel(UUID uuid) {
        return CHANNELS.get(uuid);
    }
}

