/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.entity.villager.type;

import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerType;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import java.util.HashMap;
import java.util.Map;

public class VillagerTypes {
    private static final Map<String, VillagerType> VILLAGER_TYPE_MAP = new HashMap<String, VillagerType>();
    private static final Map<Byte, VillagerType> VILLAGER_TYPE_ID_MAP = new HashMap<Byte, VillagerType>();
    public static final VillagerType DESERT = VillagerTypes.define(0, "minecraft:desert");
    public static final VillagerType JUNGLE = VillagerTypes.define(1, "minecraft:jungle");
    public static final VillagerType PLAINS = VillagerTypes.define(2, "minecraft:plains");
    public static final VillagerType SAVANNA = VillagerTypes.define(3, "minecraft:savanna");
    public static final VillagerType SNOW = VillagerTypes.define(4, "minecraft:snow");
    public static final VillagerType SWAMP = VillagerTypes.define(5, "minecraft:swamp");
    public static final VillagerType TAIGA = VillagerTypes.define(6, "minecraft:taiga");

    public static VillagerType define(final int id, String name) {
        final ResourceLocation location = new ResourceLocation(name);
        VillagerType type = new VillagerType(){

            @Override
            public ResourceLocation getName() {
                return location;
            }

            @Override
            public int getId() {
                return id;
            }
        };
        VILLAGER_TYPE_MAP.put(type.getName().toString(), type);
        VILLAGER_TYPE_ID_MAP.put((byte)type.getId(), type);
        return type;
    }

    public static VillagerType getById(int id) {
        return VILLAGER_TYPE_ID_MAP.get((byte)id);
    }

    public static VillagerType getByName(String name) {
        return VILLAGER_TYPE_MAP.get(name);
    }
}

