/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.nbt.serializer;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByte;
import com.github.retrooper.packetevents.protocol.nbt.NBTByteArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTDouble;
import com.github.retrooper.packetevents.protocol.nbt.NBTEnd;
import com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.nbt.NBTIntArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTLong;
import com.github.retrooper.packetevents.protocol.nbt.NBTLongArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTShort;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import com.github.retrooper.packetevents.protocol.nbt.serializer.NBTSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;

public class DefaultNBTSerializer
extends NBTSerializer<DataInput, DataOutput> {
    public static final DefaultNBTSerializer INSTANCE = new DefaultNBTSerializer();

    public DefaultNBTSerializer() {
        super(DataInput::readByte, DataOutput::writeByte, DataInput::readUTF, DataOutput::writeUTF);
        this.registerType(NBTType.END, 0, stream -> NBTEnd.INSTANCE, (stream, tag) -> {});
        this.registerType(NBTType.BYTE, 1, stream -> new NBTByte(stream.readByte()), (stream, tag) -> stream.writeByte(tag.getAsByte()));
        this.registerType(NBTType.SHORT, 2, stream -> new NBTShort(stream.readShort()), (stream, tag) -> stream.writeShort(tag.getAsShort()));
        this.registerType(NBTType.INT, 3, stream -> new NBTInt(stream.readInt()), (stream, tag) -> stream.writeInt(tag.getAsInt()));
        this.registerType(NBTType.LONG, 4, stream -> new NBTLong(stream.readLong()), (stream, tag) -> stream.writeLong(tag.getAsLong()));
        this.registerType(NBTType.FLOAT, 5, stream -> new NBTFloat(stream.readFloat()), (stream, tag) -> stream.writeFloat(tag.getAsFloat()));
        this.registerType(NBTType.DOUBLE, 6, stream -> new NBTDouble(stream.readDouble()), (stream, tag) -> stream.writeDouble(tag.getAsDouble()));
        this.registerType(NBTType.STRING, 8, stream -> new NBTString(stream.readUTF()), (stream, tag) -> stream.writeUTF(tag.getValue()));
        this.registerType(NBTType.BYTE_ARRAY, 7, stream -> {
            byte[] array = new byte[stream.readInt()];
            stream.readFully(array);
            return new NBTByteArray(array);
        }, (stream, tag) -> {
            byte[] array = tag.getValue();
            stream.writeInt(array.length);
            stream.write(array);
        });
        this.registerType(NBTType.INT_ARRAY, 11, stream -> {
            int[] array = new int[stream.readInt()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = stream.readInt();
            }
            return new NBTIntArray(array);
        }, (stream, tag) -> {
            int[] array = tag.getValue();
            stream.writeInt(array.length);
            for (int i : array) {
                stream.writeInt(i);
            }
        });
        this.registerType(NBTType.LONG_ARRAY, 12, stream -> {
            long[] array = new long[stream.readInt()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = stream.readLong();
            }
            return new NBTLongArray(array);
        }, (stream, tag) -> {
            long[] array = tag.getValue();
            stream.writeInt(array.length);
            for (long i : array) {
                stream.writeLong(i);
            }
        });
        this.registerType(NBTType.COMPOUND, 10, stream -> {
            NBTCompound compound = new NBTCompound();
            NBTType<?> valueType = null;
            while ((valueType = this.readTagType(stream)) != NBTType.END) {
                compound.setTag(this.readTagName(stream), this.readTag(stream, valueType));
            }
            return compound;
        }, (stream, tag) -> {
            for (Map.Entry<String, NBT> entry : tag.getTags().entrySet()) {
                NBT value = entry.getValue();
                this.writeTagType(stream, value.getType());
                this.writeTagName(stream, entry.getKey());
                this.writeTag(stream, value);
            }
            this.writeTagType(stream, NBTType.END);
        });
        this.registerType(NBTType.LIST, 9, stream -> {
            NBTType<?> valueType = this.readTagType(stream);
            int size = stream.readInt();
            if (valueType == NBTType.END && size > 0) {
                throw new IllegalStateException("Missing nbt list values tag type");
            }
            NBTList list = new NBTList(valueType);
            for (int i = 0; i < size; ++i) {
                list.addTag(this.readTag(stream, valueType));
            }
            return list;
        }, (stream, tag) -> {
            this.writeTagType(stream, tag.getTagsType());
            stream.writeInt(tag.size());
            for (NBT value : tag.getTags()) {
                this.writeTag(stream, value);
            }
        });
    }
}

