/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.stats;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.stats.Statistic;
import com.github.retrooper.packetevents.util.MappingHelper;
import com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;

public class Statistics {
    private static final Map<String, Statistic> STATISTIC_MAP = new HashMap<String, Statistic>();

    public static Statistic getById(String id) {
        return STATISTIC_MAP.get(id);
    }

    static {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isOlderThan(ServerVersion.V_1_12_2)) {
            JsonObject mapping = MappingHelper.getJSONObject("stats/statistics");
            mapping = version.isOlderThanOrEquals(ServerVersion.V_1_8_3) ? mapping.getAsJsonObject("V_1_8") : mapping.getAsJsonObject("V_1_12");
            for (final Map.Entry<String, JsonElement> entry : mapping.entrySet()) {
                final Component value = AdventureSerializer.parseComponent(entry.getValue().getAsString());
                Statistic statistic = new Statistic(){

                    @Override
                    public String getId() {
                        return (String)entry.getKey();
                    }

                    @Override
                    public Component display() {
                        return value;
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof Statistic) {
                            return ((Statistic)obj).getId().equals(this.getId());
                        }
                        return false;
                    }
                };
                STATISTIC_MAP.put(entry.getKey(), statistic);
            }
        }
    }
}

