/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.chunk.storage;

import com.github.retrooper.packetevents.protocol.world.chunk.storage.BaseStorage;
import java.util.Arrays;

public class LegacyFlexibleStorage
extends BaseStorage {
    private final long[] data;
    private final int bitsPerEntry;
    private final int size;
    private final long maxEntryValue;

    public LegacyFlexibleStorage(int bitsPerEntry, int size) {
        this(bitsPerEntry, new long[LegacyFlexibleStorage.roundToNearest(size * bitsPerEntry, 64) / 64]);
    }

    public LegacyFlexibleStorage(int bitsPerEntry, long[] data) {
        if (bitsPerEntry < 4) {
            bitsPerEntry = 4;
        }
        this.bitsPerEntry = bitsPerEntry;
        this.data = Arrays.copyOf(data, data.length);
        this.size = this.data.length * 64 / this.bitsPerEntry;
        this.maxEntryValue = (1L << this.bitsPerEntry) - 1L;
    }

    private static int roundToNearest(int value, int roundTo) {
        int remainder;
        if (roundTo == 0) {
            return 0;
        }
        if (value == 0) {
            return roundTo;
        }
        if (value < 0) {
            roundTo *= -1;
        }
        return (remainder = value % roundTo) != 0 ? value + roundTo - remainder : value;
    }

    @Override
    public int get(int index) {
        int bitIndex = index * this.bitsPerEntry;
        int startIndex = bitIndex / 64;
        int endIndex = ((index + 1) * this.bitsPerEntry - 1) / 64;
        int startBitSubIndex = bitIndex % 64;
        if (startIndex == endIndex) {
            return (int)(this.data[startIndex] >>> startBitSubIndex & this.maxEntryValue);
        }
        int endBitSubIndex = 64 - startBitSubIndex;
        return (int)((this.data[startIndex] >>> startBitSubIndex | this.data[endIndex] << endBitSubIndex) & this.maxEntryValue);
    }

    @Override
    public void set(int index, int value) {
        int bitIndex = index * this.bitsPerEntry;
        int startIndex = bitIndex / 64;
        int endIndex = ((index + 1) * this.bitsPerEntry - 1) / 64;
        int startBitSubIndex = bitIndex % 64;
        this.data[startIndex] = this.data[startIndex] & (this.maxEntryValue << startBitSubIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << startBitSubIndex;
        if (startIndex != endIndex) {
            int endBitSubIndex = 64 - startBitSubIndex;
            int j1 = this.bitsPerEntry - endBitSubIndex;
            this.data[endIndex] = this.data[endIndex] >>> j1 << j1 | ((long)value & this.maxEntryValue) >> endBitSubIndex;
        }
    }

    @Override
    public long[] getData() {
        return this.data;
    }

    @Override
    public int getBitsPerEntry() {
        return this.bitsPerEntry;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public long getMaxEntryValue() {
        return this.maxEntryValue;
    }
}

