/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.states.type;

import com.github.retrooper.packetevents.protocol.world.BlockFace;
import com.github.retrooper.packetevents.protocol.world.states.enums.Attachment;
import com.github.retrooper.packetevents.protocol.world.states.enums.Axis;
import com.github.retrooper.packetevents.protocol.world.states.enums.East;
import com.github.retrooper.packetevents.protocol.world.states.enums.Face;
import com.github.retrooper.packetevents.protocol.world.states.enums.Half;
import com.github.retrooper.packetevents.protocol.world.states.enums.Hinge;
import com.github.retrooper.packetevents.protocol.world.states.enums.Instrument;
import com.github.retrooper.packetevents.protocol.world.states.enums.Leaves;
import com.github.retrooper.packetevents.protocol.world.states.enums.Mode;
import com.github.retrooper.packetevents.protocol.world.states.enums.North;
import com.github.retrooper.packetevents.protocol.world.states.enums.Orientation;
import com.github.retrooper.packetevents.protocol.world.states.enums.Part;
import com.github.retrooper.packetevents.protocol.world.states.enums.SculkSensorPhase;
import com.github.retrooper.packetevents.protocol.world.states.enums.Shape;
import com.github.retrooper.packetevents.protocol.world.states.enums.South;
import com.github.retrooper.packetevents.protocol.world.states.enums.Thickness;
import com.github.retrooper.packetevents.protocol.world.states.enums.Tilt;
import com.github.retrooper.packetevents.protocol.world.states.enums.Type;
import com.github.retrooper.packetevents.protocol.world.states.enums.VerticalDirection;
import com.github.retrooper.packetevents.protocol.world.states.enums.West;
import java.util.HashMap;
import java.util.function.Function;

public enum StateValue {
    AGE("age", Integer::parseInt),
    ATTACHED("attached", Boolean::parseBoolean),
    ATTACHMENT("attachment", Attachment::valueOf),
    AXIS("axis", Axis::valueOf),
    BERRIES("berries", Boolean::parseBoolean),
    BITES("bites", Integer::parseInt),
    BLOOM("bloom", Boolean::parseBoolean),
    BOTTOM("bottom", Boolean::parseBoolean),
    CANDLES("candles", Integer::parseInt),
    CAN_SUMMON("can_summon", Boolean::parseBoolean),
    CHARGES("charges", Integer::parseInt),
    CONDITIONAL("conditional", Boolean::parseBoolean),
    DELAY("delay", Integer::parseInt),
    DISARMED("disarmed", Boolean::parseBoolean),
    DISTANCE("distance", Integer::parseInt),
    DOWN("down", Boolean::parseBoolean),
    DRAG("drag", Boolean::parseBoolean),
    DUSTED("dusted", Integer::parseInt),
    EAST("east", East::valueOf),
    EGGS("eggs", Integer::parseInt),
    ENABLED("enabled", Boolean::parseBoolean),
    EXTENDED("extended", Boolean::parseBoolean),
    EYE("eye", Boolean::parseBoolean),
    FACE("face", Face::valueOf),
    FACING("facing", BlockFace::valueOf),
    FLOWER_AMOUNT("flower_amount", Integer::parseInt),
    HALF("half", Half::valueOf),
    HANGING("hanging", Boolean::parseBoolean),
    HAS_BOOK("has_book", Boolean::parseBoolean),
    HAS_BOTTLE_0("has_bottle_0", Boolean::parseBoolean),
    HAS_BOTTLE_1("has_bottle_1", Boolean::parseBoolean),
    HAS_BOTTLE_2("has_bottle_2", Boolean::parseBoolean),
    HAS_RECORD("has_record", Boolean::parseBoolean),
    HATCH("hatch", Integer::parseInt),
    HINGE("hinge", Hinge::valueOf),
    HONEY_LEVEL("honey_level", Integer::parseInt),
    IN_WALL("in_wall", Boolean::parseBoolean),
    INSTRUMENT("instrument", Instrument::valueOf),
    INVERTED("inverted", Boolean::parseBoolean),
    LAYERS("layers", Integer::parseInt),
    LEAVES("leaves", Leaves::valueOf),
    LEVEL("level", Integer::parseInt),
    LIT("lit", Boolean::parseBoolean),
    LOCKED("locked", Boolean::parseBoolean),
    MODE("mode", Mode::valueOf),
    MOISTURE("moisture", Integer::parseInt),
    NORTH("north", North::valueOf),
    NOTE("note", Integer::parseInt),
    OCCUPIED("occupied", Boolean::parseBoolean),
    OPEN("open", Boolean::parseBoolean),
    ORIENTATION("orientation", Orientation::valueOf),
    PART("part", Part::valueOf),
    PERSISTENT("persistent", Boolean::parseBoolean),
    PICKLES("pickles", Integer::parseInt),
    POWER("power", Integer::parseInt),
    POWERED("powered", Boolean::parseBoolean),
    ROTATION("rotation", Integer::parseInt),
    SCULK_SENSOR_PHASE("sculk_sensor_phase", SculkSensorPhase::valueOf),
    SHAPE("shape", Shape::valueOf),
    SHORT("short", Boolean::parseBoolean),
    SHRIEKING("shrieking", Boolean::parseBoolean),
    SIGNAL_FIRE("signal_fire", Boolean::parseBoolean),
    SLOT_0_OCCUPIED("slot_0_occupied", Boolean::parseBoolean),
    SLOT_1_OCCUPIED("slot_1_occupied", Boolean::parseBoolean),
    SLOT_2_OCCUPIED("slot_2_occupied", Boolean::parseBoolean),
    SLOT_3_OCCUPIED("slot_3_occupied", Boolean::parseBoolean),
    SLOT_4_OCCUPIED("slot_4_occupied", Boolean::parseBoolean),
    SLOT_5_OCCUPIED("slot_5_occupied", Boolean::parseBoolean),
    SNOWY("snowy", Boolean::parseBoolean),
    STAGE("stage", Integer::parseInt),
    SOUTH("south", South::valueOf),
    THICKNESS("thickness", Thickness::valueOf),
    TILT("tilt", Tilt::valueOf),
    TRIGGERED("triggered", Boolean::parseBoolean),
    TYPE("type", Type::valueOf),
    UNSTABLE("unstable", Boolean::parseBoolean),
    UP("up", Boolean::parseBoolean),
    VERTICAL_DIRECTION("vertical_direction", VerticalDirection::valueOf),
    WATERLOGGED("waterlogged", Boolean::parseBoolean),
    WEST("west", West::valueOf),
    CRACKED("cracked", Boolean::parseBoolean);

    private final String name;
    private final Function<String, Object> parser;
    private static final HashMap<String, StateValue> values;

    private StateValue(String name, Function<String, Object> parser) {
        this.name = name;
        this.parser = parser;
    }

    public static StateValue byName(String name) {
        return values.get(name);
    }

    public String getName() {
        return this.name;
    }

    public Function<String, Object> getParser() {
        return this.parser;
    }

    static {
        values = new HashMap();
        for (StateValue value : StateValue.values()) {
            values.put(value.name, value);
        }
    }
}

