/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.settings;

import com.github.retrooper.packetevents.util.TimeStampMode;
import java.io.InputStream;
import java.util.function.Function;

public class PacketEventsSettings {
    private TimeStampMode timestampMode = TimeStampMode.MILLIS;
    private boolean defaultReencode = true;
    private boolean checkForUpdates = true;
    private boolean downsampleColors = true;
    private boolean bStatsEnabled = true;
    private boolean debugEnabled = false;
    private Function<String, InputStream> resourceProvider = path -> PacketEventsSettings.class.getClassLoader().getResourceAsStream((String)path);

    public PacketEventsSettings timeStampMode(TimeStampMode timeStampMode) {
        this.timestampMode = timeStampMode;
        return this;
    }

    public TimeStampMode getTimeStampMode() {
        return this.timestampMode;
    }

    public PacketEventsSettings reEncodeByDefault(boolean reEncodeByDefault) {
        this.defaultReencode = reEncodeByDefault;
        return this;
    }

    public PacketEventsSettings checkForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
        return this;
    }

    public PacketEventsSettings downsampleColors(boolean downsampleColors) {
        this.downsampleColors = downsampleColors;
        return this;
    }

    public PacketEventsSettings bStats(boolean bStatsEnabled) {
        this.bStatsEnabled = bStatsEnabled;
        return this;
    }

    public PacketEventsSettings debug(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public PacketEventsSettings customResourceProvider(Function<String, InputStream> resourceProvider) {
        this.resourceProvider = resourceProvider;
        return this;
    }

    public boolean reEncodeByDefault() {
        return this.defaultReencode;
    }

    public boolean shouldCheckForUpdates() {
        return this.checkForUpdates;
    }

    public boolean shouldDownsampleColors() {
        return this.downsampleColors;
    }

    public boolean isbStatsEnabled() {
        return this.bStatsEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public Function<String, InputStream> getResourceProvider() {
        return this.resourceProvider;
    }
}

