/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import java.util.Collections;

public class PacketTransformationUtil {
    public static PacketWrapper<?>[] transform(PacketWrapper<?> wrapper) {
        if (wrapper instanceof WrapperPlayServerDestroyEntities) {
            WrapperPlayServerDestroyEntities destroyEntities = (WrapperPlayServerDestroyEntities)wrapper;
            int len = destroyEntities.getEntityIds().length;
            if (wrapper.getServerVersion() == ServerVersion.V_1_17 && len > 1) {
                PacketWrapper[] output = new PacketWrapper[len];
                for (int i = 0; i < len; ++i) {
                    int entityId = destroyEntities.getEntityIds()[i];
                    output[i] = new WrapperPlayServerDestroyEntities(entityId);
                }
                return output;
            }
        } else if (wrapper instanceof WrapperPlayServerEntityEquipment) {
            WrapperPlayServerEntityEquipment entityEquipment = (WrapperPlayServerEntityEquipment)wrapper;
            int len = entityEquipment.getEquipment().size();
            if (entityEquipment.getServerVersion().isOlderThan(ServerVersion.V_1_16) && len > 1) {
                PacketWrapper[] output = new PacketWrapper[len];
                for (int i = 0; i < len; ++i) {
                    Equipment equipment = entityEquipment.getEquipment().get(i);
                    output[i] = new WrapperPlayServerEntityEquipment(entityEquipment.getEntityId(), Collections.singletonList(equipment));
                }
                return output;
            }
        }
        return new PacketWrapper[]{wrapper};
    }
}

