/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util.adventure;

import com.github.retrooper.packetevents.protocol.stats.Statistics;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.util.Codec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class HoverSerializer {
    private static final TagStringIO SNBT_IO = TagStringIO.get();
    private static final Codec<CompoundBinaryTag, String, IOException, IOException> SNBT_CODEC = HoverSerializer.createCodec(SNBT_IO::asCompound, SNBT_IO::asString);
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";
    static final Pattern LEGACY_NAME_PATTERN = Pattern.compile("([A-Z][a-z]+)([A-Z][a-z]+)?");

    public HoverEvent.ShowItem deserializeShowItem(GsonLike gson, JsonElement input, boolean legacy) throws IOException {
        if (legacy) {
            Component component = gson.fromJson(input, Component.class);
            HoverSerializer.assertTextComponent(component);
            CompoundBinaryTag contents = SNBT_CODEC.decode(((TextComponent)component).content());
            CompoundBinaryTag tag = contents.getCompound(ITEM_TAG);
            return HoverSerializer.createShowItem(Key.key(contents.getString("id")), contents.getByte(ITEM_COUNT, (byte)1), tag == CompoundBinaryTag.empty() ? null : BinaryTagHolder.encode(tag, SNBT_CODEC));
        }
        return gson.fromJson(input, HoverEvent.ShowItem.class);
    }

    public HoverEvent.ShowEntity deserializeShowEntity(GsonLike gson, JsonElement input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec, boolean legacy) throws IOException {
        if (legacy) {
            Component component = gson.fromJson(input, Component.class);
            HoverSerializer.assertTextComponent(component);
            CompoundBinaryTag contents = SNBT_CODEC.decode(((TextComponent)component).content());
            String type = contents.getString(ENTITY_TYPE);
            Matcher matcher = LEGACY_NAME_PATTERN.matcher(type);
            if (matcher.matches()) {
                StringJoiner joiner = new StringJoiner("_");
                joiner.add(matcher.group(1));
                if (matcher.group(2) != null) {
                    joiner.add(matcher.group(2));
                }
                type = joiner.toString().toLowerCase(Locale.ROOT);
            }
            return HoverSerializer.createShowEntity(Key.key(type), UUID.fromString(contents.getString("id")), componentCodec.decode(contents.getString(ENTITY_NAME)));
        }
        return gson.fromJson(input, HoverEvent.ShowEntity.class);
    }

    public Component deserializeShowAchievement(JsonElement input) {
        HoverSerializer.assertStringValue(input);
        return Statistics.getById(input.getAsString()).display();
    }

    private static void assertStringValue(JsonElement element) {
        if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }

    private static void assertTextComponent(Component component) {
        if (!(component instanceof TextComponent) || !component.children().isEmpty()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }

    @NotNull
    public Component serializeShowItem(@NotNull HoverEvent.ShowItem input) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.item().asString())).putByte(ITEM_COUNT, (byte)input.count());
        BinaryTagHolder nbt = input.nbt();
        if (nbt != null) {
            builder.put(ITEM_TAG, nbt.get(SNBT_CODEC));
        }
        return Component.text(SNBT_CODEC.encode(builder.build()));
    }

    @NotNull
    public Component serializeShowEntity(@NotNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.id().toString())).putString(ENTITY_TYPE, input.type().asString());
        Component name = input.name();
        if (name != null) {
            builder.putString(ENTITY_NAME, componentCodec.encode(name));
        }
        return Component.text(SNBT_CODEC.encode(builder.build()));
    }

    private static HoverEvent.ShowItem createShowItem(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, @Nullable BinaryTagHolder nbt) {
        try {
            return HoverEvent.ShowItem.showItem((Key)item, (int)count, (BinaryTagHolder)nbt);
        }
        catch (NoSuchMethodError ignored) {
            return HoverEvent.ShowItem.of(item, count, nbt);
        }
    }

    private static HoverEvent.ShowEntity createShowEntity(@NotNull Key type, @NotNull UUID id, @Nullable Component name) {
        try {
            return HoverEvent.ShowEntity.showEntity((Key)type, (UUID)id, (Component)name);
        }
        catch (NoSuchMethodError ignored) {
            return HoverEvent.ShowEntity.of(type, id, name);
        }
    }

    @NotNull
    private static <D, E, DX extends Throwable, EX extends Throwable> Codec<D, E, DX, EX> createCodec(@NotNull Codec.Decoder<D, E, DX> decoder, @NotNull Codec.Encoder<D, E, EX> encoder) {
        try {
            return Codec.codec(decoder, encoder);
        }
        catch (NoSuchMethodError ignored) {
            return Codec.of(decoder, encoder);
        }
    }

    public static interface GsonLike {
        public static GsonLike fromGson(Gson gson) {
            return gson::fromJson;
        }

        public <T> T fromJson(@Nullable JsonElement var1, Class<T> var2);
    }
}

