/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.util.adventure;

import com.github.retrooper.packetevents.util.adventure.AdventureReflectionUtil;
import com.github.retrooper.packetevents.util.adventure.StyleSerializerExtended;
import com.github.retrooper.packetevents.util.adventure.TextColorWrapper;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class SerializerFactory
implements TypeAdapterFactory {
    private final boolean downsampleColors;
    private final boolean emitLegacyHover;

    SerializerFactory(boolean downsampleColors, boolean emitLegacyHover) {
        this.downsampleColors = downsampleColors;
        this.emitLegacyHover = emitLegacyHover;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (Component.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)AdventureReflectionUtil.COMPONENT_SERIALIZER_CREATE.apply(gson);
        }
        if (Key.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.KEY_SERIALIZER_INSTANCE;
        }
        if (Style.class.isAssignableFrom(rawType)) {
            return StyleSerializerExtended.create(this.emitLegacyHover, gson);
        }
        if (ClickEvent.Action.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.CLICK_EVENT_ACTION_SERIALIZER_INSTANCE;
        }
        if (HoverEvent.Action.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.HOVER_EVENT_ACTION_SERIALIZER_INSTANCE;
        }
        if (HoverEvent.ShowItem.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)AdventureReflectionUtil.SHOW_ITEM_SERIALIZER_CREATE.apply(gson);
        }
        if (HoverEvent.ShowEntity.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)AdventureReflectionUtil.SHOW_ENTITY_SERIALIZER_CREATE.apply(gson);
        }
        if (TextColorWrapper.class.isAssignableFrom(rawType)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (TextColor.class.isAssignableFrom(rawType)) {
            return this.downsampleColors ? AdventureReflectionUtil.TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE : AdventureReflectionUtil.TEXT_COLOR_SERIALIZER_INSTANCE;
        }
        if (TextDecoration.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.TEXT_DECORATION_SERIALIZER_INSTANCE;
        }
        if (BlockNBTComponent.Pos.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.BLOCK_NBT_POS_SERIALIZER_INSTANCE;
        }
        return null;
    }
}

