/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.login.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.crypto.MinecraftEncryptionUtil;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.security.PublicKey;

public class WrapperLoginServerEncryptionRequest
extends PacketWrapper<WrapperLoginServerEncryptionRequest> {
    private String serverID;
    private byte[] publicKeyBytes;
    private byte[] verifyToken;

    public WrapperLoginServerEncryptionRequest(PacketSendEvent event) {
        super(event);
    }

    public WrapperLoginServerEncryptionRequest(String serverID, byte[] publicKeyBytes, byte[] verifyToken) {
        super(PacketType.Login.Server.ENCRYPTION_REQUEST);
        this.serverID = serverID;
        this.publicKeyBytes = publicKeyBytes;
        this.verifyToken = verifyToken;
    }

    public WrapperLoginServerEncryptionRequest(String serverID, PublicKey publicKey, byte[] verifyToken) {
        super(PacketType.Login.Server.ENCRYPTION_REQUEST);
        this.serverID = serverID;
        this.publicKeyBytes = publicKey.getEncoded();
        this.verifyToken = verifyToken;
    }

    @Override
    public void read() {
        this.serverID = this.readString(20);
        this.publicKeyBytes = this.readByteArray(512);
        this.verifyToken = this.readByteArray(ByteBufHelper.readableBytes(this.buffer));
    }

    @Override
    public void write() {
        this.writeString(this.serverID, 20);
        this.writeByteArray(this.publicKeyBytes);
        this.writeByteArray(this.verifyToken);
    }

    @Override
    public void copy(WrapperLoginServerEncryptionRequest wrapper) {
        this.serverID = wrapper.serverID;
        this.publicKeyBytes = wrapper.publicKeyBytes;
        this.verifyToken = wrapper.verifyToken;
    }

    public String getServerId() {
        return this.serverID;
    }

    public void setServerId(String serverID) {
        this.serverID = serverID;
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public void setPublicKeyBytes(byte[] publicKeyBytes) {
        this.publicKeyBytes = publicKeyBytes;
    }

    public PublicKey getPublicKey() {
        return MinecraftEncryptionUtil.publicKey(this.publicKeyBytes);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKeyBytes = publicKey.getEncoded();
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public void setVerifyToken(byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }
}

