/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.client;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayClientCraftRecipeRequest
extends PacketWrapper<WrapperPlayClientCraftRecipeRequest> {
    private int windowId;
    private int recipeLegacy;
    @Nullable
    private String recipeModern;
    private boolean makeAll;

    public WrapperPlayClientCraftRecipeRequest(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientCraftRecipeRequest(int windowId, int recipeLegacy, boolean makeAll) {
        super(PacketType.Play.Client.CRAFT_RECIPE_REQUEST);
        this.windowId = windowId;
        this.recipeLegacy = recipeLegacy;
        this.makeAll = makeAll;
    }

    public WrapperPlayClientCraftRecipeRequest(int windowId, @Nullable String recipeModern, boolean makeAll) {
        super(PacketType.Play.Client.CRAFT_RECIPE_REQUEST);
        this.windowId = windowId;
        this.recipeModern = recipeModern;
        this.makeAll = makeAll;
    }

    @Override
    public void read() {
        this.windowId = this.readByte();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.recipeModern = this.readString();
        } else {
            this.recipeLegacy = this.readVarInt();
        }
        this.makeAll = this.readBoolean();
    }

    @Override
    public void write() {
        this.writeByte(this.windowId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeString(this.recipeModern);
        } else {
            this.writeVarInt(this.recipeLegacy);
        }
        this.writeBoolean(this.makeAll);
    }

    @Override
    public void copy(WrapperPlayClientCraftRecipeRequest wrapper) {
        this.windowId = wrapper.windowId;
        this.recipeLegacy = wrapper.recipeLegacy;
        this.recipeModern = wrapper.recipeModern;
        this.makeAll = wrapper.makeAll;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public void setWindowId(int windowId) {
        this.windowId = windowId;
    }

    public <T> T getRecipe() {
        return (T)(this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? this.recipeModern : Integer.valueOf(this.recipeLegacy));
    }

    public <T> void setRecipe(T recipe) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.recipeModern = (String)recipe;
        } else {
            this.recipeLegacy = (Integer)recipe;
        }
    }

    public boolean isMakeAll() {
        return this.makeAll;
    }

    public void setMakeAll(boolean makeAll) {
        this.makeAll = makeAll;
    }
}

