/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.client;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientEntityAction
extends PacketWrapper<WrapperPlayClientEntityAction> {
    private int entityID;
    private Action action;
    private int jumpBoost;

    public WrapperPlayClientEntityAction(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientEntityAction(int entityID, Action action, int jumpBoost) {
        super(PacketType.Play.Client.ENTITY_ACTION);
        this.entityID = entityID;
        this.action = action;
        this.jumpBoost = jumpBoost;
    }

    @Override
    public void read() {
        boolean v1_8 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8);
        this.entityID = v1_8 ? this.readVarInt() : this.readInt();
        int id = v1_8 ? this.readVarInt() : (int)this.readByte();
        this.action = Action.getById(this.serverVersion, id);
        this.jumpBoost = v1_8 ? this.readVarInt() : this.readInt();
    }

    @Override
    public void write() {
        boolean v1_8 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8);
        if (v1_8) {
            this.writeVarInt(this.entityID);
            int actionIndex = this.action.getId(this.serverVersion);
            this.writeVarInt(actionIndex);
            this.writeVarInt(this.jumpBoost);
        } else {
            this.writeInt(this.entityID);
            int actionIndex = this.action.getId(this.serverVersion);
            this.writeByte(actionIndex);
            this.writeInt(this.jumpBoost);
        }
    }

    @Override
    public void copy(WrapperPlayClientEntityAction wrapper) {
        this.entityID = wrapper.entityID;
        this.action = wrapper.action;
        this.jumpBoost = wrapper.jumpBoost;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public int getJumpBoost() {
        return this.jumpBoost;
    }

    public void setJumpBoost(int jumpBoost) {
        this.jumpBoost = jumpBoost;
    }

    public static enum Action {
        START_SNEAKING,
        STOP_SNEAKING,
        LEAVE_BED,
        START_SPRINTING,
        STOP_SPRINTING,
        START_JUMPING_WITH_HORSE,
        STOP_JUMPING_WITH_HORSE,
        OPEN_HORSE_INVENTORY,
        START_FLYING_WITH_ELYTRA;

        private static final Action[] VALUES;

        public int getId(ServerVersion serverVersion) {
            int actionIndex = this.ordinal();
            if (serverVersion.isOlderThan(ServerVersion.V_1_9) && this == OPEN_HORSE_INVENTORY) {
                --actionIndex;
            }
            return actionIndex;
        }

        public static Action getById(ServerVersion serverVersion, int id) {
            if (id >= VALUES.length || id < 0) {
                throw new IllegalStateException("EntityAction action out of bounds: " + id);
            }
            Action action = VALUES[id];
            if (serverVersion.isOlderThan(ServerVersion.V_1_9) && action == STOP_JUMPING_WITH_HORSE) {
                action = OPEN_HORSE_INVENTORY;
            }
            return action;
        }

        static {
            VALUES = Action.values();
        }
    }
}

