/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.recipe.Ingredient;
import com.github.retrooper.packetevents.protocol.recipe.Recipe;
import com.github.retrooper.packetevents.protocol.recipe.RecipeType;
import com.github.retrooper.packetevents.protocol.recipe.data.CookedRecipeData;
import com.github.retrooper.packetevents.protocol.recipe.data.RecipeData;
import com.github.retrooper.packetevents.protocol.recipe.data.ShapedRecipeData;
import com.github.retrooper.packetevents.protocol.recipe.data.ShapelessRecipeData;
import com.github.retrooper.packetevents.protocol.recipe.data.SmithingRecipeData;
import com.github.retrooper.packetevents.protocol.recipe.data.StoneCuttingRecipeData;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Locale;

public class WrapperPlayServerDeclareRecipes
extends PacketWrapper<WrapperPlayServerDeclareRecipes> {
    private Recipe[] recipes;

    public WrapperPlayServerDeclareRecipes(PacketSendEvent event) {
        super(event);
    }

    public Recipe[] getRecipes() {
        return this.recipes;
    }

    public void setRecipes(Recipe[] recipes) {
        this.recipes = recipes;
    }

    @Override
    public void read() {
        this.recipes = new Recipe[this.readVarInt()];
        for (int i = 0; i < this.recipes.length; ++i) {
            RecipeType type = RecipeType.valueOf(this.readString().replace("minecraft:", "").toUpperCase(Locale.ROOT));
            String identifier = this.readString();
            RecipeData data = null;
            switch (type) {
                case CRAFTING_SHAPELESS: {
                    String group = this.readString();
                    Ingredient[] ingredients = new Ingredient[this.readVarInt()];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = this.readIngredient();
                    }
                    ItemStack result = this.readItemStack();
                    data = new ShapelessRecipeData(group, ingredients, result);
                    break;
                }
                case CRAFTING_SHAPED: {
                    int width = this.readVarInt();
                    int height = this.readVarInt();
                    String group = this.readString();
                    Ingredient[] ingredients = new Ingredient[width * height];
                    for (int j = 0; j < ingredients.length; ++j) {
                        ingredients[j] = this.readIngredient();
                    }
                    ItemStack result = this.readItemStack();
                    data = new ShapedRecipeData(width, height, group, ingredients, result);
                    break;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    String group = this.readString();
                    Ingredient ingredient = this.readIngredient();
                    ItemStack result = this.readItemStack();
                    float experience = this.readFloat();
                    int cookingTime = this.readVarInt();
                    data = new CookedRecipeData(group, ingredient, result, experience, cookingTime);
                    break;
                }
                case STONECUTTING: {
                    String group = this.readString();
                    Ingredient ingredient = this.readIngredient();
                    ItemStack result = this.readItemStack();
                    data = new StoneCuttingRecipeData(group, ingredient, result);
                    break;
                }
                case SMITHING: {
                    Ingredient base = this.readIngredient();
                    Ingredient addition = this.readIngredient();
                    ItemStack result = this.readItemStack();
                    data = new SmithingRecipeData(base, addition, result);
                    break;
                }
            }
            this.recipes[i] = new Recipe(type, identifier, data);
        }
    }

    private Ingredient readIngredient() {
        ItemStack[] options = new ItemStack[this.readVarInt()];
        for (int i = 0; i < options.length; ++i) {
            options[i] = this.readItemStack();
        }
        return new Ingredient(options);
    }

    private void writeIngredient(Ingredient ingredient) {
        this.writeVarInt(ingredient.getOptions().length);
        for (ItemStack option : ingredient.getOptions()) {
            this.writeItemStack(option);
        }
    }

    @Override
    public void copy(WrapperPlayServerDeclareRecipes wrapper) {
        this.recipes = wrapper.recipes;
    }

    @Override
    public void write() {
        this.writeVarInt(this.recipes.length);
        block7: for (Recipe recipe : this.recipes) {
            this.writeString("minecraft:" + recipe.getType().toString().toLowerCase(Locale.ROOT));
            this.writeString(recipe.getIdentifier());
            switch (recipe.getType()) {
                case CRAFTING_SHAPELESS: {
                    RecipeData data = (ShapelessRecipeData)recipe.getData();
                    this.writeString(((ShapelessRecipeData)data).getGroup());
                    this.writeVarInt(((ShapelessRecipeData)data).getIngredients().length);
                    for (Ingredient ingredient : ((ShapelessRecipeData)data).getIngredients()) {
                        this.writeIngredient(ingredient);
                    }
                    this.writeItemStack(((ShapelessRecipeData)data).getResult());
                    continue block7;
                }
                case CRAFTING_SHAPED: {
                    RecipeData data = (ShapedRecipeData)recipe.getData();
                    if (((ShapedRecipeData)data).getIngredients().length != ((ShapedRecipeData)data).getWidth() * ((ShapedRecipeData)data).getHeight()) {
                        throw new IllegalStateException("Shaped recipe must have ingredient count equal to width * height.");
                    }
                    this.writeVarInt(((ShapedRecipeData)data).getWidth());
                    this.writeVarInt(((ShapedRecipeData)data).getHeight());
                    this.writeString(((ShapedRecipeData)data).getGroup());
                    for (Ingredient ingredient : ((ShapedRecipeData)data).getIngredients()) {
                        this.writeIngredient(ingredient);
                    }
                    this.writeItemStack(((ShapedRecipeData)data).getResult());
                    continue block7;
                }
                case SMELTING: 
                case BLASTING: 
                case SMOKING: 
                case CAMPFIRE_COOKING: {
                    RecipeData data = (CookedRecipeData)recipe.getData();
                    this.writeString(((CookedRecipeData)data).getGroup());
                    this.writeIngredient(((CookedRecipeData)data).getIngredient());
                    this.writeItemStack(((CookedRecipeData)data).getResult());
                    this.writeFloat(((CookedRecipeData)data).getExperience());
                    this.writeVarInt(((CookedRecipeData)data).getCookingTime());
                    continue block7;
                }
                case STONECUTTING: {
                    RecipeData data = (StoneCuttingRecipeData)recipe.getData();
                    this.writeString(((StoneCuttingRecipeData)data).getGroup());
                    this.writeIngredient(((StoneCuttingRecipeData)data).getIngredient());
                    this.writeItemStack(((StoneCuttingRecipeData)data).getResult());
                    continue block7;
                }
                case SMITHING: {
                    RecipeData data = (SmithingRecipeData)recipe.getData();
                    this.writeIngredient(((SmithingRecipeData)data).getBase());
                    this.writeIngredient(((SmithingRecipeData)data).getAddition());
                    this.writeItemStack(((SmithingRecipeData)data).getResult());
                    continue block7;
                }
            }
        }
    }
}

