/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;

public class WrapperPlayServerExplosion
extends PacketWrapper<WrapperPlayServerExplosion> {
    private Vector3d position;
    private float strength;
    private List<Vector3i> records;
    private Vector3f playerMotion;

    public WrapperPlayServerExplosion(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.records = records;
        this.playerMotion = playerMotion;
    }

    @Override
    public void read() {
        this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) ? new Vector3d(this.readDouble(), this.readDouble(), this.readDouble()) : new Vector3d(this.readFloat(), this.readFloat(), this.readFloat());
        this.strength = this.readFloat();
        int recordsLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.records = new ArrayList<Vector3i>(recordsLength);
        Vector3i floor = this.toFloor(this.position);
        for (int i = 0; i < recordsLength; ++i) {
            int chunkPosX = this.readByte() + floor.getX();
            int chunkPosY = this.readByte() + floor.getY();
            int chunkPosZ = this.readByte() + floor.getZ();
            this.records.add(new Vector3i(chunkPosX, chunkPosY, chunkPosZ));
        }
        float motX = this.readFloat();
        float motY = this.readFloat();
        float motZ = this.readFloat();
        this.playerMotion = new Vector3f(motX, motY, motZ);
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            this.writeDouble(this.position.getX());
            this.writeDouble(this.position.getY());
            this.writeDouble(this.position.getZ());
        } else {
            this.writeFloat((float)this.position.getX());
            this.writeFloat((float)this.position.getY());
            this.writeFloat((float)this.position.getZ());
        }
        this.writeFloat(this.strength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.records.size());
        } else {
            this.writeInt(this.records.size());
        }
        Vector3i floor = this.toFloor(this.position);
        for (Vector3i record : this.records) {
            this.writeByte(record.x - floor.getX());
            this.writeByte(record.y - floor.getY());
            this.writeByte(record.z - floor.getZ());
        }
        this.writeFloat(this.playerMotion.x);
        this.writeFloat(this.playerMotion.y);
        this.writeFloat(this.playerMotion.z);
    }

    @Override
    public void copy(WrapperPlayServerExplosion wrapper) {
        this.position = wrapper.position;
        this.strength = wrapper.strength;
        this.records = wrapper.records;
        this.playerMotion = wrapper.playerMotion;
    }

    private Vector3i toFloor(Vector3d position) {
        int floorZ;
        int floorY;
        int floorX;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            floorX = (int)Math.floor(position.x);
            floorY = (int)Math.floor(position.y);
            floorZ = (int)Math.floor(position.z);
        } else {
            floorX = (int)position.x;
            floorY = (int)position.y;
            floorZ = (int)position.z;
        }
        return new Vector3i(floorX, floorY, floorZ);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public List<Vector3i> getRecords() {
        return this.records;
    }

    public void setRecords(List<Vector3i> records) {
        this.records = records;
    }

    public Vector3f getPlayerMotion() {
        return this.playerMotion;
    }

    public void setPlayerMotion(Vector3f playerMotion) {
        this.playerMotion = playerMotion;
    }
}

