/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.LegacyConvertible;
import com.github.retrooper.packetevents.protocol.particle.data.LegacyParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleType;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerParticle
extends PacketWrapper<WrapperPlayServerParticle> {
    private Particle particle;
    private boolean longDistance;
    private Vector3d position;
    private Vector3f offset;
    private float maxSpeed;
    private int particleCount;

    public WrapperPlayServerParticle(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerParticle(Particle particle, boolean longDistance, Vector3d position, Vector3f offset, float maxSpeed, int particleCount) {
        super(PacketType.Play.Server.PARTICLE);
        this.particle = particle;
        this.longDistance = longDistance;
        this.position = position;
        this.offset = offset;
        this.maxSpeed = maxSpeed;
        this.particleCount = particleCount;
    }

    @Override
    public void read() {
        ParticleData data;
        ParticleType particleType;
        int particleTypeId = 0;
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            String particleName = this.readString(64);
            particleType = ParticleTypes.getByName("minecraft:" + particleName);
        } else {
            particleTypeId = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19) ? this.readVarInt() : this.readInt();
            particleType = ParticleTypes.getById(this.serverVersion.toClientVersion(), particleTypeId);
        }
        this.longDistance = this.readBoolean();
        this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15) ? new Vector3d(this.readDouble(), this.readDouble(), this.readDouble()) : new Vector3d(this.readFloat(), this.readFloat(), this.readFloat());
        this.offset = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
        this.maxSpeed = this.readFloat();
        this.particleCount = this.readInt();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            data = particleType.readDataFunction().apply(this);
        } else {
            data = new ParticleData();
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
                data = LegacyParticleData.read(this, particleTypeId);
            }
        }
        this.particle = new Particle(particleType, data);
    }

    @Override
    public void write() {
        int id = this.particle.getType().getId(this.serverVersion.toClientVersion());
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeString(this.particle.getType().getName().getKey(), 64);
        } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeVarInt(id);
        } else {
            this.writeInt(id);
        }
        this.writeBoolean(this.longDistance);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15)) {
            this.writeDouble(this.position.getX());
            this.writeDouble(this.position.getY());
            this.writeDouble(this.position.getZ());
        } else {
            this.writeFloat((float)this.position.getX());
            this.writeFloat((float)this.position.getY());
            this.writeFloat((float)this.position.getZ());
        }
        this.writeFloat(this.offset.getX());
        this.writeFloat(this.offset.getY());
        this.writeFloat(this.offset.getZ());
        this.writeFloat(this.maxSpeed);
        this.writeInt(this.particleCount);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.particle.getType().writeDataFunction().accept(this, this.particle.getData());
        } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            LegacyParticleData legacyData = this.particle.getData() instanceof LegacyConvertible ? ((LegacyConvertible)((Object)this.particle.getData())).toLegacy(this.serverVersion.toClientVersion()) : LegacyParticleData.nullValue(id);
            LegacyParticleData.write(this, id, legacyData);
        }
    }

    @Override
    public void copy(WrapperPlayServerParticle wrapper) {
        this.particle = wrapper.particle;
        this.longDistance = wrapper.longDistance;
        this.position = wrapper.position;
        this.offset = wrapper.offset;
        this.maxSpeed = wrapper.maxSpeed;
        this.particleCount = wrapper.particleCount;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public boolean isLongDistance() {
        return this.longDistance;
    }

    public void setLongDistance(boolean longDistance) {
        this.longDistance = longDistance;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }
}

