/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.teleport.RelativeFlag;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerPlayerPositionAndLook
extends PacketWrapper<WrapperPlayServerPlayerPositionAndLook> {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private byte relativeMask;
    private int teleportId;
    private boolean dismountVehicle = false;

    public WrapperPlayServerPlayerPositionAndLook(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerPlayerPositionAndLook(double x, double y, double z, float yaw, float pitch, byte flags, int teleportId, boolean dismountVehicle) {
        super(PacketType.Play.Server.PLAYER_POSITION_AND_LOOK);
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.relativeMask = flags;
        this.teleportId = teleportId;
        this.dismountVehicle = dismountVehicle;
    }

    @Override
    public void read() {
        this.x = this.readDouble();
        this.y = this.readDouble();
        this.z = this.readDouble();
        this.yaw = this.readFloat();
        this.pitch = this.readFloat();
        this.relativeMask = (byte)this.readUnsignedByte();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.teleportId = this.readVarInt();
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) && this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_3)) {
            this.dismountVehicle = this.readBoolean();
        }
    }

    @Override
    public void write() {
        this.writeDouble(this.x);
        this.writeDouble(this.y);
        this.writeDouble(this.z);
        this.writeFloat(this.yaw);
        this.writeFloat(this.pitch);
        this.writeByte(this.relativeMask);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.writeVarInt(this.teleportId);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) && this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_3)) {
            this.writeBoolean(this.dismountVehicle);
        }
    }

    @Override
    public void copy(WrapperPlayServerPlayerPositionAndLook wrapper) {
        this.x = wrapper.x;
        this.y = wrapper.y;
        this.z = wrapper.z;
        this.yaw = wrapper.yaw;
        this.pitch = wrapper.pitch;
        this.relativeMask = wrapper.relativeMask;
        this.teleportId = wrapper.teleportId;
        this.dismountVehicle = wrapper.dismountVehicle;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public byte getRelativeMask() {
        return this.relativeMask;
    }

    public void setRelativeMask(byte relativeMask) {
        this.relativeMask = relativeMask;
    }

    public boolean isRelativeFlag(RelativeFlag flag) {
        return flag.isSet(this.relativeMask);
    }

    public void setRelative(RelativeFlag flag, boolean relative) {
        this.relativeMask = flag.set(this.relativeMask, relative);
    }

    public RelativeFlag getRelativeFlags() {
        return new RelativeFlag(this.relativeMask);
    }

    public void setRelativeFlags(RelativeFlag flags) {
        this.relativeMask = flags.getMask();
    }

    public int getTeleportId() {
        return this.teleportId;
    }

    public void setTeleportId(int teleportId) {
        this.teleportId = teleportId;
    }

    public boolean isDismountVehicle() {
        return this.dismountVehicle;
    }

    public void setDismountVehicle(boolean dismountVehicle) {
        this.dismountVehicle = dismountVehicle;
    }
}

