/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerTitle
extends PacketWrapper<WrapperPlayServerTitle> {
    public static boolean HANDLE_JSON = true;
    private TitleAction action;
    @Nullable
    private Component title;
    @Nullable
    private String titleJson;
    @Nullable
    private Component subtitle;
    @Nullable
    private String subtitleJson;
    @Nullable
    private Component actionBar;
    @Nullable
    private String actionBarJson;
    private int fadeInTicks;
    private int stayTicks;
    private int fadeOutTicks;

    public WrapperPlayServerTitle(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerTitle(TitleAction action, @Nullable Component title, @Nullable Component subtitle, @Nullable Component actionBar, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(PacketType.Play.Server.TITLE);
        this.action = action;
        this.title = title;
        this.subtitle = subtitle;
        this.actionBar = actionBar;
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    public WrapperPlayServerTitle(TitleAction action, @Nullable String titleJson, @Nullable String subtitleJson, @Nullable String actionBarJson, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(PacketType.Play.Server.TITLE);
        this.action = action;
        this.titleJson = titleJson;
        this.subtitleJson = subtitleJson;
        this.actionBarJson = actionBarJson;
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    @Override
    public void read() {
        boolean modern = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11);
        int id = this.readVarInt();
        this.action = modern ? TitleAction.fromId(id) : TitleAction.fromLegacyId(id);
        switch (Objects.requireNonNull(this.action)) {
            case SET_TITLE: {
                this.titleJson = this.readComponentJSON();
                if (!HANDLE_JSON) break;
                this.title = AdventureSerializer.parseComponent(this.titleJson);
                break;
            }
            case SET_SUBTITLE: {
                this.subtitleJson = this.readComponentJSON();
                if (!HANDLE_JSON) break;
                this.subtitle = AdventureSerializer.parseComponent(this.subtitleJson);
                break;
            }
            case SET_ACTION_BAR: {
                this.actionBarJson = this.readComponentJSON();
                if (!HANDLE_JSON) break;
                this.actionBar = AdventureSerializer.parseComponent(this.actionBarJson);
                break;
            }
            case SET_TIMES_AND_DISPLAY: {
                this.fadeInTicks = this.readInt();
                this.stayTicks = this.readInt();
                this.fadeOutTicks = this.readInt();
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerTitle wrapper) {
        this.action = wrapper.action;
        this.title = wrapper.title;
        this.titleJson = wrapper.titleJson;
        this.subtitle = wrapper.subtitle;
        this.subtitleJson = wrapper.subtitleJson;
        this.actionBar = wrapper.actionBar;
        this.actionBarJson = wrapper.actionBarJson;
        this.fadeInTicks = wrapper.fadeInTicks;
        this.stayTicks = wrapper.stayTicks;
        this.fadeOutTicks = wrapper.fadeOutTicks;
    }

    @Override
    public void write() {
        boolean modern = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11);
        int id = modern ? this.action.getId() : this.action.getLegacyId();
        this.writeVarInt(id);
        switch (this.action) {
            case SET_TITLE: {
                if (HANDLE_JSON && this.title != null) {
                    this.titleJson = AdventureSerializer.toJson(this.title);
                }
                this.writeComponentJSON(this.titleJson);
                break;
            }
            case SET_SUBTITLE: {
                if (HANDLE_JSON && this.subtitle != null) {
                    this.subtitleJson = AdventureSerializer.toJson(this.subtitle);
                }
                this.writeComponentJSON(this.subtitleJson);
                break;
            }
            case SET_ACTION_BAR: {
                if (HANDLE_JSON && this.actionBar != null) {
                    this.actionBarJson = AdventureSerializer.toJson(this.actionBar);
                }
                this.writeComponentJSON(this.actionBarJson);
                break;
            }
            case SET_TIMES_AND_DISPLAY: {
                this.writeInt(this.fadeInTicks);
                this.writeInt(this.stayTicks);
                this.writeInt(this.fadeOutTicks);
            }
        }
    }

    public TitleAction getAction() {
        return this.action;
    }

    public void setAction(TitleAction action) {
        this.action = action;
    }

    @Nullable
    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable Component title) {
        this.title = title;
    }

    @Nullable
    public String getTitleJson() {
        return this.titleJson;
    }

    public void setTitleJson(@Nullable String titleJson) {
        this.titleJson = titleJson;
    }

    @Nullable
    public Component getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(@Nullable Component subtitle) {
        this.subtitle = subtitle;
    }

    @Nullable
    public String getSubtitleJson() {
        return this.subtitleJson;
    }

    public void setSubtitleJson(@Nullable String subtitleJson) {
        this.subtitleJson = subtitleJson;
    }

    @Nullable
    public Component getActionBar() {
        return this.actionBar;
    }

    public void setActionBar(@Nullable Component actionBar) {
        this.actionBar = actionBar;
    }

    @Nullable
    public String getActionBarJson() {
        return this.actionBarJson;
    }

    public void setActionBarJson(@Nullable String actionBarJson) {
        this.actionBarJson = actionBarJson;
    }

    public int getFadeInTicks() {
        return this.fadeInTicks;
    }

    public void setFadeInTicks(int fadeInTicks) {
        this.fadeInTicks = fadeInTicks;
    }

    public int getStayTicks() {
        return this.stayTicks;
    }

    public void setStayTicks(int stayTicks) {
        this.stayTicks = stayTicks;
    }

    public int getFadeOutTicks() {
        return this.fadeOutTicks;
    }

    public void setFadeOutTicks(int fadeOutTicks) {
        this.fadeOutTicks = fadeOutTicks;
    }

    public static enum TitleAction {
        SET_TITLE(0),
        SET_SUBTITLE(1),
        SET_ACTION_BAR,
        SET_TIMES_AND_DISPLAY(2),
        HIDE(3),
        RESET(4);

        private final int legacyId;

        private TitleAction() {
            this(-1);
        }

        private TitleAction(int legacyId) {
            this.legacyId = legacyId;
        }

        public static TitleAction fromId(int id) {
            return TitleAction.values()[id];
        }

        public static TitleAction fromLegacyId(int legacyId) {
            for (TitleAction action : TitleAction.values()) {
                if (action.legacyId != legacyId) continue;
                return action;
            }
            return null;
        }

        public int getId() {
            return this.ordinal();
        }

        public int getLegacyId() {
            return this.legacyId;
        }
    }
}

