/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.wrapper.play.server;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public class WrapperPlayServerUpdateScore
extends PacketWrapper<WrapperPlayServerUpdateScore> {
    private String entityName;
    private Action action;
    private String objectiveName;
    private Optional<Integer> value;

    public WrapperPlayServerUpdateScore(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerUpdateScore(String entityName, Action action, String objectiveName, Optional<Integer> value) {
        super(PacketType.Play.Server.UPDATE_SCORE);
        this.entityName = entityName;
        this.action = action;
        this.objectiveName = objectiveName;
        this.value = value;
    }

    @Override
    public void read() {
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.entityName = this.readString(16);
            this.action = Action.VALUES[this.readByte()];
            if (this.action != Action.REMOVE_ITEM) {
                this.objectiveName = this.readString(16);
                this.value = Optional.of(this.readInt());
            } else {
                this.objectiveName = "";
                this.value = Optional.empty();
            }
        } else {
            this.entityName = this.readString(40);
            this.action = Action.VALUES[this.readByte()];
            this.objectiveName = this.readString(16);
            if (this.action != Action.REMOVE_ITEM) {
                this.value = Optional.of(this.readVarInt());
            } else {
                this.objectiveName = "";
                this.value = Optional.empty();
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeString(this.entityName, 16);
            this.writeByte(this.action.ordinal());
            if (this.action != Action.REMOVE_ITEM) {
                this.writeString(this.objectiveName, 16);
                this.writeInt(this.value.orElse(-1));
            } else {
                this.objectiveName = "";
                this.value = Optional.empty();
            }
        } else {
            this.writeString(this.entityName, 40);
            this.writeByte(this.action.ordinal());
            this.writeString(this.objectiveName, 16);
            if (this.action != Action.REMOVE_ITEM) {
                this.writeVarInt(this.value.orElse(-1));
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerUpdateScore wrapper) {
        this.entityName = wrapper.entityName;
        this.action = wrapper.action;
        this.objectiveName = wrapper.objectiveName;
        this.value = wrapper.value;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public void setObjectiveName(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public Optional<Integer> getValue() {
        return this.value;
    }

    public void setValue(Optional<Integer> value) {
        this.value = value;
    }

    public static enum Action {
        CREATE_OR_UPDATE_ITEM,
        REMOVE_ITEM;

        public static final Action[] VALUES;

        static {
            VALUES = Action.values();
        }
    }
}

