/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.npc.module.command;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.command.ICommandSender;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.service.ICloudServiceManager;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroupManager;
import eu.thesimplecloud.launcher.console.command.CommandType;
import eu.thesimplecloud.launcher.console.command.ICommandHandler;
import eu.thesimplecloud.launcher.console.command.annotations.Command;
import eu.thesimplecloud.launcher.console.command.annotations.CommandArgument;
import eu.thesimplecloud.launcher.console.command.annotations.CommandSubPath;
import eu.thesimplecloud.module.npc.lib.config.NPCModuleConfig;
import eu.thesimplecloud.module.npc.lib.config.NPCModuleConfigHandler;
import eu.thesimplecloud.module.npc.lib.config.npc.CloudNPCData;
import eu.thesimplecloud.module.npc.lib.config.npc.LocationData;
import eu.thesimplecloud.module.npc.lib.config.npc.NPCItem;
import eu.thesimplecloud.module.npc.lib.config.npc.SkinData;
import eu.thesimplecloud.module.npc.lib.config.npc.action.NPCAction;
import eu.thesimplecloud.module.npc.lib.config.npc.settings.MobNPCSettings;
import eu.thesimplecloud.module.npc.lib.config.npc.settings.NPCSettings;
import eu.thesimplecloud.module.npc.lib.config.npc.settings.PlayerNPCSettings;
import eu.thesimplecloud.module.npc.lib.type.MobType;
import eu.thesimplecloud.module.npc.module.NPCModule;
import eu.thesimplecloud.module.npc.module.command.provider.CloudNPCMobTypeCommandSuggestionProvider;
import eu.thesimplecloud.module.npc.module.command.provider.ServicesWithoutProxiesCommandSuggestionProvider;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Command(name="cloudnpc", commandType=CommandType.INGAME, permission="cloud.module.npc", aliases={"npc", "npcs", "cloudnpcs"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0002J8\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u0017\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\bH\u0007J.\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u0017\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Leu/thesimplecloud/module/npc/module/command/CreateNpcCommand;", "Leu/thesimplecloud/launcher/console/command/ICommandHandler;", "()V", "npcModuleConfigHandler", "Leu/thesimplecloud/module/npc/lib/config/NPCModuleConfigHandler;", "cantBeCreatedOnThisService", "", "name", "", "createNewNpc", "", "player", "Leu/thesimplecloud/api/player/ICloudPlayer;", "displayName", "id", "targetServiceGroup", "skinData", "Leu/thesimplecloud/module/npc/lib/config/npc/SkinData;", "mobType", "executeCreateMob", "sender", "Leu/thesimplecloud/api/command/ICommandSender;", "type", "targetService", "executeCreatePlayer", "simplecloud-module-npc"})
public final class CreateNpcCommand
implements ICommandHandler {
    @NotNull
    private final NPCModuleConfigHandler npcModuleConfigHandler = NPCModule.Companion.getInstance().getNpcModuleConfigHandler();

    @CommandSubPath(path="create player <id> <targetService> <displayName>", description="Create a npc.")
    public final void executeCreatePlayer(@NotNull ICommandSender sender, @CommandArgument(name="id") @NotNull String id, @CommandArgument(name="targetService", suggestionProvider=ServicesWithoutProxiesCommandSuggestionProvider.class) @NotNull String targetService, @CommandArgument(name="displayName") @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)targetService, (String)"targetService");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        ICloudPlayer player = (ICloudPlayer)sender;
        NPCModuleConfig config = this.npcModuleConfigHandler.load();
        if (config.getNpcsConfig().existNpcWithId(id)) {
            player.sendProperty("manager.command.npc.create.failed.id.already.exist", new String[0]);
            return;
        }
        if (this.cantBeCreatedOnThisService(targetService)) {
            player.sendProperty("manager.command.npc.failed.group.not.found", new String[0]);
            return;
        }
        SkinData skinData = new SkinData("ewogICJ0aW1lc3RhbXAiIDogMTYyNDUyNjI0NjM2MywKICAicHJvZmlsZUlkIiA6ICIwNjlhNzlmNDQ0ZTk0NzI2YTViZWZjYTkwZTM4YWFmNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJOb3RjaCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS8yOTIwMDlhNDkyNWI1OGYwMmM3N2RhZGMzZWNlZjA3ZWE0Yzc0NzJmNjRlMGZkYzMyY2U1NTIyNDg5MzYyNjgwIgogICAgfQogIH0KfQ==", "K76X+5wYgbcKhUxr5ZJuF4MXquYNPM5ypUf6DdNz2k0+XaJlobLVVdETe2LotlHyj6ABoU3//8mGZnfwhdj2BiulOErpB6cQR4pMmIrW6T3TLCt4L8d9juQy7xy7Dw9sQngXWm2h3Cazm+205qa0apnvA/i+IGv+WeutP52kfGhJBAN7uBUQaut0NWBfFPL8Jo7DhwBvWf/KWVpcT9UcVQuS/dVP/VE0rrTTSf3x2/jGI0ksBEdOz5lROARCHwOA1sRDvP1nQHhZD1Uekj4Bmo6rsAjJCrzr++nK2IcaPMv1uTLv0sbsGe4JF884rqWHYzs7/Cc5lGv8FNy+QjHmTcISfjnlxwJIkI48KOmAjuaova+tU1gBHRFHqJR186Vw8gtIGHusitFr6rUuutODaHyJ1C9VnItyk5RF3eznsh+uUHSkT9NOCTAhx11UhaFjlIHgqHG3rRVmeFWyEKHE8Pk2yEAlROGPedp+oYEwMFbM97Q+og7W/RtSH+kYl9vNwpLrQEG2F0bQUtulwQrWzk8T2fKgPHncZIDS2YvQjrrHjjlG0bLbiakHGvRrMrLbrVtmQrKjOjLuc5j4M/quMoZpFz98q4uftCmNOyN9ZmoEjgFv5fOdsJDGJawSaug9VEieCWhuuPnXPx19GpT1TRzGRjDW9DqO08kNeCcRxq0=");
        CreateNpcCommand.createNewNpc$default(this, player, displayName, id, targetService, skinData, null, 32, null);
    }

    @CommandSubPath(path="create mob <type> <id> <targetService> <displayName>", description="Create a npc.")
    public final void executeCreateMob(@NotNull ICommandSender sender, @CommandArgument(name="type", suggestionProvider=CloudNPCMobTypeCommandSuggestionProvider.class) @NotNull String type, @CommandArgument(name="id") @NotNull String id, @CommandArgument(name="targetService", suggestionProvider=ServicesWithoutProxiesCommandSuggestionProvider.class) @NotNull String targetService, @CommandArgument(name="displayName") @NotNull String displayName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)targetService, (String)"targetService");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        ICloudPlayer player = (ICloudPlayer)sender;
        NPCModuleConfig config = this.npcModuleConfigHandler.load();
        if (config.getNpcsConfig().existNpcWithId(id)) {
            player.sendProperty("manager.command.npc.create.failed.id.already.exist", new String[0]);
            return;
        }
        if (this.cantBeCreatedOnThisService(targetService)) {
            player.sendProperty("manager.command.npc.failed.group.not.found", new String[0]);
            return;
        }
        Object object = NPCModule.Companion.getInstance().getMobCollection();
        if (object != null && (object = ((MobType)object).getTypes()) != null) {
            String string = type.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            bl = object.contains(string);
        } else {
            bl = false;
        }
        if (!bl) {
            player.sendProperty("manager.command.npc.could.not.find.type", new String[0]);
            return;
        }
        String string = type.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        CreateNpcCommand.createNewNpc$default(this, player, displayName, id, targetService, null, string, 16, null);
    }

    private final boolean cantBeCreatedOnThisService(String name) {
        ICloudServiceGroupManager cloudServiceGroupManager = CloudAPI.Companion.getInstance().getCloudServiceGroupManager();
        ICloudServiceManager cloudServiceManager = CloudAPI.Companion.getInstance().getCloudServiceManager();
        return cloudServiceGroupManager.getServiceGroupByName(name) == null && cloudServiceManager.getCloudServiceByName(name) == null;
    }

    private final void createNewNpc(ICloudPlayer player, String displayName, String id, String targetServiceGroup, SkinData skinData, String mobType) {
        NPCModuleConfig config = this.npcModuleConfigHandler.load();
        player.getLocation().addResultListener((Function1)new Function1<ServiceLocation, Unit>(mobType, skinData, displayName, id, player, targetServiceGroup, config, this){
            final /* synthetic */ String $mobType;
            final /* synthetic */ SkinData $skinData;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $id;
            final /* synthetic */ ICloudPlayer $player;
            final /* synthetic */ String $targetServiceGroup;
            final /* synthetic */ NPCModuleConfig $config;
            final /* synthetic */ CreateNpcCommand this$0;
            {
                this.$mobType = $mobType;
                this.$skinData = $skinData;
                this.$displayName = $displayName;
                this.$id = $id;
                this.$player = $player;
                this.$targetServiceGroup = $targetServiceGroup;
                this.$config = $config;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ServiceLocation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NPCSettings npcSettings = new NPCSettings(false, false, new MobNPCSettings(this.$mobType, ""), new PlayerNPCSettings(this.$skinData, false, false, false, false, 30, null), 3, null);
                Object[] objectArray = new String[]{"\u00a78\u00bb \u00a77Online \u00a7b%PLAYERS_ONLINE% \u00a78\u00ab", "\u00a78\u00bb \u00a77%DISPLAYNAME% \u00a78\u00ab"};
                CloudNPCData cloudNPCData = new CloudNPCData(this.$displayName, this.$id, !Intrinsics.areEqual((Object)this.$mobType, (Object)""), this.$player.getConnectedServerName(), this.$targetServiceGroup, new LocationData(it.getGroupName(), it.getWorldName(), it.getX(), it.getY(), it.getZ(), it.getYaw(), it.getPitch()), new NPCAction(null, null, 3, null), new NPCItem(null, null), npcSettings, CollectionsKt.listOf((Object[])objectArray));
                this.$config.getNpcsConfig().getNpcs().add(cloudNPCData);
                this.$config.update();
                CreateNpcCommand.access$getNpcModuleConfigHandler$p(this.this$0).save(this.$config);
                this.$player.sendProperty("manager.command.npc.create.successfully", new String[0]);
            }
        }).addFailureListener((Function1)new Function1<Throwable, Unit>(player){
            final /* synthetic */ ICloudPlayer $player;
            {
                this.$player = $player;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$player.sendProperty("manager.command.npc.create.failed.unknown.location", new String[0]);
            }
        });
    }

    static /* synthetic */ void createNewNpc$default(CreateNpcCommand createNpcCommand, ICloudPlayer iCloudPlayer, String string, String string2, String string3, SkinData skinData, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            skinData = new SkinData("", "");
        }
        if ((n & 0x20) != 0) {
            string4 = "";
        }
        createNpcCommand.createNewNpc(iCloudPlayer, string, string2, string3, skinData, string4);
    }

    public static final /* synthetic */ NPCModuleConfigHandler access$getNpcModuleConfigHandler$p(CreateNpcCommand $this) {
        return $this.npcModuleConfigHandler;
    }
}

