/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.npc.module.skin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0004J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\rH\u0002J6\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Leu/thesimplecloud/module/npc/module/skin/SkinHandler;", "", "()V", "endpointGetSkinByID", "", "endpointGetSkinByUUID", "endpointGetUUIDByName", "requestExecutor", "Ljava/util/concurrent/Executor;", "formatUuid", "Ljava/util/UUID;", "uuidString", "getJsonObjectFromEndpoint", "Lcom/google/gson/JsonObject;", "endpoint", "getRequestResponse", "getSkinConfigByID", "Ljava/util/concurrent/CompletableFuture;", "Leu/thesimplecloud/module/npc/module/skin/SkinHandler$SkinConfig;", "id", "getSkinConfigByName", "name", "getUUIDFromName", "parseSkinConfigByID", "jsonObject", "parseSkinConfigByName", "processRequest", "param", "endpointTemplate", "parser", "Lkotlin/Function1;", "SkinConfig", "simplecloud-module-npc"})
@SourceDebugExtension(value={"SMAP\nSkinHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinHandler.kt\neu/thesimplecloud/module/npc/module/skin/SkinHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class SkinHandler {
    @NotNull
    private final Executor requestExecutor;
    @NotNull
    private final String endpointGetSkinByID;
    @NotNull
    private final String endpointGetUUIDByName;
    @NotNull
    private final String endpointGetSkinByUUID;

    public SkinHandler() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.requestExecutor = executorService;
        this.endpointGetSkinByID = "https://api.mineskin.org/get/uuid/%s";
        this.endpointGetUUIDByName = "https://api.mineskin.org/validate/name/%s";
        this.endpointGetSkinByUUID = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    }

    @NotNull
    public final CompletableFuture<SkinConfig> getSkinConfigByID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.processRequest(id, this.endpointGetSkinByID, (Function1<? super JsonObject, SkinConfig>)((Function1)new Function1<JsonObject, SkinConfig>((Object)this){

            @Nullable
            public final SkinConfig invoke(@NotNull JsonObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SkinHandler.access$parseSkinConfigByID((SkinHandler)this.receiver, p0);
            }
        }));
    }

    @NotNull
    public final CompletableFuture<SkinConfig> getSkinConfigByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getUUIDFromName(name);
        if (object == null || (object = ((UUID)object).toString()) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
            return completableFuture;
        }
        Object uuid = object;
        return this.processRequest((String)uuid, this.endpointGetSkinByUUID, (Function1<? super JsonObject, SkinConfig>)((Function1)new Function1<JsonObject, SkinConfig>((Object)this){

            @Nullable
            public final SkinConfig invoke(@NotNull JsonObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SkinHandler.access$parseSkinConfigByName((SkinHandler)this.receiver, p0);
            }
        }));
    }

    private final CompletableFuture<SkinConfig> processRequest(String param, String endpointTemplate, Function1<? super JsonObject, SkinConfig> parser) {
        Object[] objectArray = new Object[]{param};
        String string = String.format(endpointTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        String endpoint = string;
        CompletableFuture<SkinConfig> completableFuture = CompletableFuture.supplyAsync(() -> SkinHandler.processRequest$lambda$0(this, endpoint, parser), this.requestExecutor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync({\n          \u2026      }, requestExecutor)");
        return completableFuture;
    }

    private final JsonObject getJsonObjectFromEndpoint(String endpoint) {
        String result = this.getRequestResponse(endpoint);
        JsonElement jsonElement = JsonParser.parseString(result);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonElement.asJsonObject");
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getRequestResponse(String endpoint) {
        URL url = new URL(endpoint);
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + responseCode);
        }
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object input = object2;
        connection.disconnect();
        return input;
    }

    private final SkinConfig parseSkinConfigByID(JsonObject jsonObject) {
        SkinConfig skinConfig;
        JsonObject texture;
        JsonObject jsonObject2 = jsonObject.getAsJsonObject("data");
        JsonObject jsonObject3 = texture = jsonObject2 != null ? jsonObject2.getAsJsonObject("texture") : null;
        if (jsonObject3 != null) {
            JsonObject it = jsonObject3;
            boolean bl = false;
            String string = it.get("value").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it[\"value\"].asString");
            String string2 = it.get("signature").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it[\"signature\"].asString");
            skinConfig = new SkinConfig(string, string2);
        } else {
            skinConfig = null;
        }
        return skinConfig;
    }

    private final SkinConfig parseSkinConfigByName(JsonObject jsonObject) {
        SkinConfig skinConfig;
        JsonObject properties;
        JsonElement jsonElement = jsonObject.getAsJsonArray("properties");
        JsonObject jsonObject2 = properties = jsonElement != null && (jsonElement = ((JsonArray)jsonElement).get(0)) != null ? jsonElement.getAsJsonObject() : null;
        if (jsonObject2 != null) {
            JsonObject it = jsonObject2;
            boolean bl = false;
            String string = it.get("value").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it[\"value\"].asString");
            String string2 = it.get("signature").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it[\"signature\"].asString");
            skinConfig = new SkinConfig(string, string2);
        } else {
            skinConfig = null;
        }
        return skinConfig;
    }

    private final UUID getUUIDFromName(String name) {
        String string = this.endpointGetUUIDByName;
        Object[] objectArray = new Object[]{name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String endpoint = string2;
        JsonObject jsonObject = this.getJsonObjectFromEndpoint(endpoint);
        if (!jsonObject.get("valid").getAsBoolean()) {
            return null;
        }
        String uuidString = jsonObject.get("uuid").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)uuidString, (String)"uuidString");
        return this.formatUuid(uuidString);
    }

    private final UUID formatUuid(String uuidString) {
        CharSequence charSequence = uuidString;
        Regex regex = new Regex("(.{8})(.{4})(.{4})(.{4})(.{12})");
        String string = "$1-$2-$3-$4-$5";
        String formattedUuid = regex.replace(charSequence, string);
        UUID uUID = UUID.fromString(formattedUuid);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(formattedUuid)");
        return uUID;
    }

    private static final SkinConfig processRequest$lambda$0(SkinHandler this$0, String $endpoint, Function1 $parser) {
        SkinConfig skinConfig;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$endpoint, (String)"$endpoint");
        Intrinsics.checkNotNullParameter((Object)$parser, (String)"$parser");
        try {
            JsonObject jsonObject = this$0.getJsonObjectFromEndpoint($endpoint);
            skinConfig = (SkinConfig)$parser.invoke((Object)jsonObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            skinConfig = null;
        }
        return skinConfig;
    }

    public static final /* synthetic */ SkinConfig access$parseSkinConfigByID(SkinHandler $this, JsonObject jsonObject) {
        return $this.parseSkinConfigByID(jsonObject);
    }

    public static final /* synthetic */ SkinConfig access$parseSkinConfigByName(SkinHandler $this, JsonObject jsonObject) {
        return $this.parseSkinConfigByName(jsonObject);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/npc/module/skin/SkinHandler$SkinConfig;", "", "value", "", "signature", "(Ljava/lang/String;Ljava/lang/String;)V", "getSignature", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "simplecloud-module-npc"})
    public static final class SkinConfig {
        @NotNull
        private final String value;
        @NotNull
        private final String signature;

        public SkinConfig(@NotNull String value, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            this.value = value;
            this.signature = signature;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getSignature() {
            return this.signature;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.signature;
        }

        @NotNull
        public final SkinConfig copy(@NotNull String value, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            return new SkinConfig(value, signature);
        }

        public static /* synthetic */ SkinConfig copy$default(SkinConfig skinConfig, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = skinConfig.value;
            }
            if ((n & 2) != 0) {
                string2 = skinConfig.signature;
            }
            return skinConfig.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "SkinConfig(value=" + this.value + ", signature=" + this.signature + ')';
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + this.signature.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkinConfig)) {
                return false;
            }
            SkinConfig skinConfig = (SkinConfig)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)skinConfig.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.signature, (Object)skinConfig.signature);
        }
    }
}

