/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.npc.plugin.inventory;

import com.cryptomorin.xseries.XMaterial;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.npc.lib.config.NPCModuleConfig;
import eu.thesimplecloud.module.npc.lib.extension.StringKt;
import eu.thesimplecloud.module.npc.plugin.NPCPlugin;
import eu.thesimplecloud.module.npc.plugin.inventory.InventoryData;
import eu.thesimplecloud.module.npc.plugin.npc.ServerNPCHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Leu/thesimplecloud/module/npc/plugin/inventory/InventoryHandler;", "", "npcPlugin", "Leu/thesimplecloud/module/npc/plugin/NPCPlugin;", "(Leu/thesimplecloud/module/npc/plugin/NPCPlugin;)V", "cache", "", "Ljava/util/UUID;", "", "inventories", "", "Leu/thesimplecloud/module/npc/plugin/inventory/InventoryData;", "getInventories", "()Ljava/util/List;", "getMaterial", "Lorg/bukkit/inventory/ItemStack;", "service", "Leu/thesimplecloud/api/service/ICloudService;", "config", "Leu/thesimplecloud/module/npc/lib/config/NPCModuleConfig;", "open", "", "player", "Lorg/bukkit/entity/Player;", "group", "", "simplecloud-module-npc"})
@SourceDebugExtension(value={"SMAP\nInventoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventoryHandler.kt\neu/thesimplecloud/module/npc/plugin/inventory/InventoryHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n215#2,2:112\n766#3:114\n857#3,2:115\n1855#3:117\n1855#3,2:118\n1856#3:120\n*S KotlinDebug\n*F\n+ 1 InventoryHandler.kt\neu/thesimplecloud/module/npc/plugin/inventory/InventoryHandler\n*L\n47#1:112,2\n58#1:114\n58#1:115,2\n58#1:117\n76#1:118,2\n58#1:120\n*E\n"})
public final class InventoryHandler {
    @NotNull
    private final NPCPlugin npcPlugin;
    @NotNull
    private final Map<UUID, Long> cache;
    @NotNull
    private final List<InventoryData> inventories;

    public InventoryHandler(@NotNull NPCPlugin npcPlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)npcPlugin), (String)"npcPlugin");
        this.npcPlugin = npcPlugin;
        this.cache = new LinkedHashMap();
        this.inventories = new ArrayList();
    }

    @NotNull
    public final List<InventoryData> getInventories() {
        return this.inventories;
    }

    /*
     * WARNING - void declaration
     */
    public final void open(@NotNull Player player, @NotNull String group) {
        void $this$filterTo$iv$iv;
        Map.Entry<Integer, String> element$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Map<UUID, Long> map = this.cache;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        if (map.containsKey(uUID)) {
            Long l = this.cache.get(player.getUniqueId());
            Intrinsics.checkNotNull((Object)l);
            if (((Number)l).longValue() > System.currentTimeMillis()) {
                return;
            }
        }
        map = this.cache;
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"player.uniqueId");
        UUID uUID3 = uUID2;
        Long l = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L);
        map.put(uUID3, l);
        ICloudServiceGroup serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(group);
        if (serviceGroup == null) {
            Bukkit.getLogger().warning("[SimpleCloud-NPC] The inventory is not supported for CloudServices!");
            return;
        }
        ServerNPCHandler serverNPCHandler = this.npcPlugin.getServerNPCHandler();
        Intrinsics.checkNotNull((Object)serverNPCHandler);
        NPCModuleConfig config = serverNPCHandler.getConfig();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)((InventoryHolder)player), (int)(9 * config.getInventorySettingsConfig().getRows()), (String)StringKt.translateColorCodesFromString(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)config.getInventorySettingsConfig().getInventoryName(), (String)"%TARGET_GROUP%", (String)serviceGroup.getName(), (boolean)false, (int)4, null), (String)"%TEMPLATE_NAME%", (String)serviceGroup.getTemplateName(), (boolean)false, (int)4, null), (String)"%MAX_PLAYERS%", (String)String.valueOf(serviceGroup.getMaxPlayers()), (boolean)false, (int)4, null)));
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"createInventory(player,\n\u2026teColorCodesFromString())");
        Inventory inventory2 = inventory;
        InventoryData inventoryData = new InventoryData(group, inventory2, null, 4, null);
        Map<Integer, String> $this$forEach$iv = config.getInventorySettingsConfig().getInventory();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ItemMeta itemMeta;
            Map.Entry<Integer, String> entry = element$iv = iterator.next();
            boolean bl = false;
            int slot = ((Number)entry.getKey()).intValue();
            String material = entry.getValue();
            XMaterial xMaterial = XMaterial.valueOf(material);
            ItemStack itemStack = xMaterial.parseItem();
            if (itemStack == null) continue;
            Intrinsics.checkNotNull((Object)itemStack.getItemMeta());
            itemMeta.setDisplayName(" ");
            itemStack.setItemMeta(itemMeta);
            inventory2.setItem(slot, itemStack);
        }
        Iterable $this$filter$iv = serviceGroup.getAllServices();
        boolean $i$f$filter = false;
        iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl2 = false;
            if (!it.isOnline()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            ItemMeta itemMeta;
            element$iv = iterator.next();
            ICloudService service = (ICloudService)element$iv;
            boolean bl = false;
            ItemStack itemStack = this.getMaterial(service, config);
            Intrinsics.checkNotNull((Object)itemStack.getItemMeta());
            itemMeta.setDisplayName(StringKt.translateColorCodesFromString(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)config.getInventorySettingsConfig().getItemName(), (String)"%SERVICE_NAME%", (String)service.getName(), (boolean)false, (int)4, null), (String)"%TEMPLATE_NAME%", (String)service.getTemplateName(), (boolean)false, (int)4, null), (String)"%WRAPPER_NAME%", (String)service.getWrapper().getName(), (boolean)false, (int)4, null), (String)"%DISPLAYNAME%", (String)service.getDisplayName(), (boolean)false, (int)4, null), (String)"%ONLINE_PLAYERS%", (String)String.valueOf(service.getOnlineCount()), (boolean)false, (int)4, null), (String)"%HOST%", (String)service.getHost(), (boolean)false, (int)4, null), (String)"%PORT%", (String)String.valueOf(service.getPort()), (boolean)false, (int)4, null), (String)"%STATE%", (String)service.getState().name(), (boolean)false, (int)4, null), (String)"%NUMBER%", (String)String.valueOf(service.getServiceNumber()), (boolean)false, (int)4, null), (String)"%MAX_PLAYERS%", (String)String.valueOf(service.getMaxPlayers()), (boolean)false, (int)4, null), (String)"%MOTD%", (String)service.getMOTD(), (boolean)false, (int)4, null)));
            Iterable bl2 = config.getInventorySettingsConfig().getLore();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl3 = false;
                List list = itemMeta.getLore();
                List lore = list == null ? (List)new ArrayList() : list;
                lore.add(StringKt.translateColorCodesFromString(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"%SERVICE_NAME%", (String)service.getName(), (boolean)false, (int)4, null), (String)"%TEMPLATE_NAME%", (String)service.getTemplateName(), (boolean)false, (int)4, null), (String)"%WRAPPER_NAME%", (String)service.getWrapper().getName(), (boolean)false, (int)4, null), (String)"%DISPLAYNAME%", (String)service.getDisplayName(), (boolean)false, (int)4, null), (String)"%ONLINE_PLAYERS%", (String)String.valueOf(service.getOnlineCount()), (boolean)false, (int)4, null), (String)"%HOST%", (String)service.getHost(), (boolean)false, (int)4, null), (String)"%PORT%", (String)String.valueOf(service.getPort()), (boolean)false, (int)4, null), (String)"%STATE%", (String)service.getState().name(), (boolean)false, (int)4, null), (String)"%NUMBER%", (String)String.valueOf(service.getServiceNumber()), (boolean)false, (int)4, null), (String)"%MAX_PLAYERS%", (String)String.valueOf(service.getMaxPlayers()), (boolean)false, (int)4, null), (String)"%MOTD%", (String)service.getMOTD(), (boolean)false, (int)4, null)));
                itemMeta.setLore(lore);
            }
            itemStack.setItemMeta(itemMeta);
            ItemStack[] itemStackArray = new ItemStack[]{itemStack};
            inventory2.addItem(itemStackArray);
            inventoryData.getItems().put(itemStack, service.getName());
        }
        player.openInventory(inventory2);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.8f, 0.8f);
        this.inventories.add(inventoryData);
    }

    private final ItemStack getMaterial(ICloudService service, NPCModuleConfig config) {
        ItemStack itemStack;
        if (service.isFull()) {
            ItemStack itemStack2 = XMaterial.valueOf(config.getInventorySettingsConfig().getFullService()).parseItem();
            Intrinsics.checkNotNull((Object)itemStack2);
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"{\n            XMaterial.\u2026).parseItem()!!\n        }");
        } else {
            ItemStack itemStack3 = XMaterial.valueOf(config.getInventorySettingsConfig().getOnlineService()).parseItem();
            Intrinsics.checkNotNull((Object)itemStack3);
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"{\n            XMaterial.\u2026).parseItem()!!\n        }");
        }
        return itemStack;
    }
}

