/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.npc.plugin.npc;

import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.bukkit.BukkitPlatform;
import com.github.juliarn.npclib.bukkit.BukkitWorldAccessor;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.module.npc.lib.config.NPCModuleConfig;
import eu.thesimplecloud.module.npc.lib.config.npc.CloudNPCData;
import eu.thesimplecloud.module.npc.plugin.NPCPlugin;
import eu.thesimplecloud.module.npc.plugin.npc.type.AbstractServerNPC;
import eu.thesimplecloud.module.npc.plugin.npc.type.MobNPC;
import eu.thesimplecloud.module.npc.plugin.npc.type.PlayerNPC;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR)\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Leu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler;", "", "npcPlugin", "Leu/thesimplecloud/module/npc/plugin/NPCPlugin;", "(Leu/thesimplecloud/module/npc/plugin/NPCPlugin;)V", "config", "Leu/thesimplecloud/module/npc/lib/config/NPCModuleConfig;", "getConfig", "()Leu/thesimplecloud/module/npc/lib/config/NPCModuleConfig;", "setConfig", "(Leu/thesimplecloud/module/npc/lib/config/NPCModuleConfig;)V", "getNpcPlugin", "()Leu/thesimplecloud/module/npc/plugin/NPCPlugin;", "platform", "Lcom/github/juliarn/npclib/api/Platform;", "Lorg/bukkit/World;", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/inventory/ItemStack;", "Lorg/bukkit/plugin/Plugin;", "getPlatform", "()Lcom/github/juliarn/npclib/api/Platform;", "serverNPC", "", "", "Leu/thesimplecloud/module/npc/plugin/npc/type/AbstractServerNPC;", "getServerNPC", "()Ljava/util/Map;", "createNPCs", "", "deleteNPCs", "isRightService", "", "serviceName", "updateScoreboardTeam", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "npcName", "simplecloud-module-npc"})
@SourceDebugExtension(value={"SMAP\nServerNPCHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerNPCHandler.kt\neu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,83:1\n766#2:84\n857#2,2:85\n1855#2:87\n1855#2,2:88\n1856#2:90\n215#3,2:91\n*S KotlinDebug\n*F\n+ 1 ServerNPCHandler.kt\neu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler\n*L\n37#1:84\n37#1:85,2\n38#1:87\n52#1:88,2\n38#1:90\n60#1:91,2\n*E\n"})
public final class ServerNPCHandler {
    @NotNull
    private final NPCPlugin npcPlugin;
    public NPCModuleConfig config;
    @NotNull
    private final Platform<World, Player, ItemStack, Plugin> platform;
    @NotNull
    private final Map<String, AbstractServerNPC> serverNPC;

    public ServerNPCHandler(@NotNull NPCPlugin npcPlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)npcPlugin), (String)"npcPlugin");
        this.npcPlugin = npcPlugin;
        Platform platform = BukkitPlatform.bukkitNpcPlatformBuilder().extension(this.npcPlugin).debug(true).worldAccessor(BukkitWorldAccessor.nameBasedAccessor()).actionController(ServerNPCHandler::platform$lambda$0).build();
        Intrinsics.checkNotNullExpressionValue(platform, (String)"bukkitNpcPlatformBuilder\u2026ller { }\n        .build()");
        this.platform = platform;
        this.serverNPC = new LinkedHashMap();
    }

    @NotNull
    public final NPCPlugin getNpcPlugin() {
        return this.npcPlugin;
    }

    @NotNull
    public final NPCModuleConfig getConfig() {
        NPCModuleConfig nPCModuleConfig = this.config;
        if (nPCModuleConfig != null) {
            return nPCModuleConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull NPCModuleConfig nPCModuleConfig) {
        Intrinsics.checkNotNullParameter((Object)nPCModuleConfig, (String)"<set-?>");
        this.config = nPCModuleConfig;
    }

    @NotNull
    public final Platform<World, Player, ItemStack, Plugin> getPlatform() {
        return this.platform;
    }

    @NotNull
    public final Map<String, AbstractServerNPC> getServerNPC() {
        return this.serverNPC;
    }

    /*
     * WARNING - void declaration
     */
    public final void createNPCs() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getConfig().getNpcsConfig().getNpcs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CloudNPCData it = (CloudNPCData)element$iv$iv;
            boolean bl = false;
            if (!this.isRightService(it.getCreatedInThisGroup())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudNPCData npcInformation = (CloudNPCData)element$iv;
            boolean bl = false;
            AbstractServerNPC npc = npcInformation.isMob() ? (AbstractServerNPC)new MobNPC(this, npcInformation) : (AbstractServerNPC)new PlayerNPC(this, npcInformation);
            npc.onSetup();
            npc.spawnHolograms();
            this.serverNPC.put(npcInformation.getId(), npc);
            if (npcInformation.isMob()) continue;
            PlayerNPC playerNPC = (PlayerNPC)npc;
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers()");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Player it = (Player)element$iv2;
                boolean bl2 = false;
                Scoreboard scoreboard = it.getScoreboard();
                Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"it.scoreboard");
                String string = playerNPC.getNpc().profile().name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"playerNPC.npc.profile().name()");
                this.updateScoreboardTeam(scoreboard, string);
            }
        }
    }

    public final void deleteNPCs() {
        Map<String, AbstractServerNPC> $this$forEach$iv = this.serverNPC;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, AbstractServerNPC>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, AbstractServerNPC> element$iv;
            Map.Entry<String, AbstractServerNPC> entry = element$iv = iterator.next();
            boolean bl = false;
            AbstractServerNPC npc = entry.getValue();
            ServerNPCHandler $this$deleteNPCs_u24lambda_u245_u24lambda_u244 = this;
            boolean bl2 = false;
            npc.onRemove();
            npc.deleteHolograms();
        }
        this.serverNPC.clear();
    }

    public final void updateScoreboardTeam(@NotNull Scoreboard scoreboard, @NotNull String npcName) {
        Intrinsics.checkNotNullParameter((Object)scoreboard, (String)"scoreboard");
        Intrinsics.checkNotNullParameter((Object)npcName, (String)"npcName");
        Team team = scoreboard.getTeam("simpleCloudNpc");
        if (team == null) {
            team = scoreboard.registerNewTeam("simpleCloudNpc");
        }
        Intrinsics.checkNotNullExpressionValue((Object)team, (String)"scoreboard.getTeam(\"simp\u2026NewTeam(\"simpleCloudNpc\")");
        Team team2 = team;
        team2.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        team2.addEntry(npcName);
    }

    private final boolean isRightService(String serviceName) {
        if (serviceName == null) {
            return true;
        }
        ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();
        return Intrinsics.areEqual((Object)thisService.getName(), (Object)serviceName) || Intrinsics.areEqual((Object)thisService.getGroupName(), (Object)serviceName);
    }

    private static final void platform$lambda$0(NpcActionController.Builder it) {
    }
}

