/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.npc.plugin.npc.type;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.npc.lib.config.npc.CloudNPCData;
import eu.thesimplecloud.module.npc.lib.config.npc.LocationData;
import eu.thesimplecloud.module.npc.lib.config.npc.action.Action;
import eu.thesimplecloud.module.npc.lib.config.npc.action.NPCAction;
import eu.thesimplecloud.module.npc.lib.extension.StringKt;
import eu.thesimplecloud.module.npc.plugin.NPCPlugin;
import eu.thesimplecloud.module.npc.plugin.npc.ServerNPCHandler;
import eu.thesimplecloud.module.npc.plugin.npc.type.ServerNPC;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0015J \u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020 H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Leu/thesimplecloud/module/npc/plugin/npc/type/AbstractServerNPC;", "Leu/thesimplecloud/module/npc/plugin/npc/type/ServerNPC;", "serverNPCHandler", "Leu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler;", "config", "Leu/thesimplecloud/module/npc/lib/config/npc/CloudNPCData;", "(Leu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler;Leu/thesimplecloud/module/npc/lib/config/npc/CloudNPCData;)V", "getConfig", "()Leu/thesimplecloud/module/npc/lib/config/npc/CloudNPCData;", "holograms", "", "Lorg/bukkit/entity/ArmorStand;", "npcLocation", "Lorg/bukkit/Location;", "getNpcLocation", "()Lorg/bukkit/Location;", "setNpcLocation", "(Lorg/bukkit/Location;)V", "getServerNPCHandler", "()Leu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler;", "deleteHolograms", "", "handleClickInteract", "player", "Lorg/bukkit/entity/Player;", "clickAction", "Leu/thesimplecloud/module/npc/lib/config/npc/action/Action;", "handleGroupQuickJoin", "serviceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "handleHologramUpdating", "serviceName", "", "handleInventory", "handleQuickJoin", "handleRunCommand", "handleServiceQuickJoin", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "handlingInteract", "rightClicked", "", "spawnHolograms", "updateHolograms", "onlinePlayersCount", "", "servicesOnlineCount", "templateName", "simplecloud-module-npc"})
@SourceDebugExtension(value={"SMAP\nAbstractServerNPC.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractServerNPC.kt\neu/thesimplecloud/module/npc/plugin/npc/type/AbstractServerNPC\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Runnable.kt\nkotlinx/coroutines/RunnableKt\n*L\n1#1,147:1\n1#2:148\n1855#3,2:149\n1855#3,2:151\n766#3:154\n857#3,2:155\n288#3,2:157\n17#4:153\n*S KotlinDebug\n*F\n+ 1 AbstractServerNPC.kt\neu/thesimplecloud/module/npc/plugin/npc/type/AbstractServerNPC\n*L\n70#1:149,2\n83#1:151,2\n131#1:154\n131#1:155,2\n132#1:157,2\n107#1:153\n*E\n"})
public abstract class AbstractServerNPC
implements ServerNPC {
    @NotNull
    private final ServerNPCHandler serverNPCHandler;
    @NotNull
    private final CloudNPCData config;
    public Location npcLocation;
    @NotNull
    private final List<ArmorStand> holograms;

    public AbstractServerNPC(@NotNull ServerNPCHandler serverNPCHandler, @NotNull CloudNPCData config) {
        Intrinsics.checkNotNullParameter((Object)serverNPCHandler, (String)"serverNPCHandler");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.serverNPCHandler = serverNPCHandler;
        this.config = config;
        this.holograms = new ArrayList();
    }

    @NotNull
    public final ServerNPCHandler getServerNPCHandler() {
        return this.serverNPCHandler;
    }

    @NotNull
    public final CloudNPCData getConfig() {
        return this.config;
    }

    @NotNull
    public final Location getNpcLocation() {
        Location location = this.npcLocation;
        if (location != null) {
            return location;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"npcLocation");
        return null;
    }

    public final void setNpcLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"<set-?>");
        this.npcLocation = location;
    }

    public final void spawnHolograms() {
        LocationData locationData = this.config.getLocationData();
        Location location = new Location(Bukkit.getWorld((String)locationData.getWorld()), locationData.getX(), locationData.getY() + this.getEntityHigh() - 0.3, locationData.getZ());
        int n = this.config.getLines().size();
        for (int i = 0; i < n; ++i) {
            ArmorStand armorStand;
            int it = i;
            boolean bl = false;
            World world = location.getWorld();
            ArmorStand armorStand2 = armorStand = world != null ? (ArmorStand)world.spawn(location.add(0.0, 0.3, 0.0), ArmorStand.class) : null;
            if (armorStand2 != null) {
                armorStand2.setGravity(false);
            }
            ArmorStand armorStand3 = armorStand;
            if (armorStand3 != null) {
                armorStand3.setMarker(true);
            }
            ArmorStand armorStand4 = armorStand;
            if (armorStand4 != null) {
                armorStand4.setInvulnerable(true);
            }
            ArmorStand armorStand5 = armorStand;
            if (armorStand5 != null) {
                armorStand5.setCustomNameVisible(true);
            }
            ArmorStand armorStand6 = armorStand;
            if (armorStand6 != null) {
                armorStand6.setCustomName("Loading");
            }
            ArmorStand armorStand7 = armorStand;
            if (armorStand7 != null) {
                armorStand7.setVisible(false);
            }
            if (armorStand != null) {
                this.holograms.add(armorStand);
                continue;
            }
            System.out.println((Object)("Can not spawn hologram for the npc " + this.config.getId()));
        }
        this.handleHologramUpdating(this.config.getTargetGroup());
    }

    public final void handleHologramUpdating(@NotNull String serviceName) {
        block1: {
            ICloudService cloudService;
            ICloudServiceGroup serviceGroup;
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            ICloudServiceGroup iCloudServiceGroup = serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(serviceName);
            if (iCloudServiceGroup != null) {
                ICloudServiceGroup it = iCloudServiceGroup;
                boolean bl = false;
                this.updateHolograms(it.getOnlinePlayerCount(), it.getOnlineServiceCount(), it.getTemplateName());
            }
            ICloudService iCloudService = cloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serviceName);
            if (iCloudService == null) break block1;
            ICloudService it = iCloudService;
            boolean bl = false;
            this.updateHolograms(it.getOnlineCount(), 1, it.getTemplateName());
        }
    }

    private final void updateHolograms(int onlinePlayersCount, int servicesOnlineCount, String templateName) {
        int i = 0;
        Iterable $this$forEach$iv = this.holograms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArmorStand armorStand = (ArmorStand)element$iv;
            boolean bl = false;
            armorStand.setCustomName(StringKt.translateColorCodesFromString(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.config.getLines().get(i), (String)"%PLAYERS_ONLINE%", (String)String.valueOf(onlinePlayersCount), (boolean)false, (int)4, null), (String)"%SERVICES_ONLINE%", (String)String.valueOf(servicesOnlineCount), (boolean)false, (int)4, null), (String)"%DISPLAYNAME%", (String)this.config.getDisplayName(), (boolean)false, (int)4, null), (String)"%SERVICE%", (String)this.config.getTargetGroup(), (boolean)false, (int)4, null), (String)"%TEMPLATE%", (String)templateName, (boolean)false, (int)4, null)));
            ++i;
        }
    }

    public final void deleteHolograms() {
        Iterable $this$forEach$iv = this.holograms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArmorStand it = (ArmorStand)element$iv;
            boolean bl = false;
            it.remove();
        }
    }

    public final void handlingInteract(@NotNull Player player, boolean rightClicked) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NPCAction action = this.config.getNpcAction();
        if (rightClicked) {
            this.handleClickInteract(player, action.getRightClick());
        } else {
            this.handleClickInteract(player, action.getLeftClick());
        }
    }

    private final void handleClickInteract(Player player, Action clickAction) {
        switch (WhenMappings.$EnumSwitchMapping$0[clickAction.ordinal()]) {
            case 1: {
                this.handleQuickJoin(player);
                break;
            }
            case 2: {
                this.handleInventory(player);
                break;
            }
            case 3: {
                this.handleRunCommand(player);
            }
        }
    }

    private final void handleRunCommand(Player player) {
        String string = this.config.getNpcSettings().getMobNPCSettings().getRunCommandName();
        if (string == null) {
            return;
        }
        String runCommandName = string;
        boolean $i$f$Runnable = false;
        Bukkit.getScheduler().runTask((Plugin)NPCPlugin.Companion.getInstance(), new Runnable(player, runCommandName){
            final /* synthetic */ Player $player$inlined;
            final /* synthetic */ String $runCommandName$inlined;
            {
                this.$player$inlined = player;
                this.$runCommandName$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                Bukkit.dispatchCommand((CommandSender)((CommandSender)this.$player$inlined), (String)this.$runCommandName$inlined);
            }
        });
    }

    private final void handleQuickJoin(Player player) {
        block1: {
            ICloudService cloudService;
            ICloudServiceGroup serviceGroup;
            String serviceName = this.config.getTargetGroup();
            ICloudServiceGroup iCloudServiceGroup = serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(serviceName);
            if (iCloudServiceGroup != null) {
                ICloudServiceGroup it = iCloudServiceGroup;
                boolean bl = false;
                this.handleGroupQuickJoin(player, it);
            }
            ICloudService iCloudService = cloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serviceName);
            if (iCloudService == null) break block1;
            ICloudService it = iCloudService;
            boolean bl = false;
            this.handleServiceQuickJoin(player, it);
        }
    }

    private final void handleServiceQuickJoin(Player player, ICloudService cloudService) {
        ICloudPlayer cloudPlayer = PlayerExtensionsKt.getCloudPlayer((Player)player);
        cloudPlayer.connect(cloudService);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleGroupQuickJoin(Player player, ICloudServiceGroup serviceGroup) {
        Object v0;
        ICloudPlayer cloudPlayer;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            cloudPlayer = PlayerExtensionsKt.getCloudPlayer((Player)player);
            Iterable iterable = serviceGroup.getAllServices();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getState() == ServiceState.VISIBLE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ICloudService it = (ICloudService)element$iv;
                boolean bl = false;
                if (!(!it.isFull())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ICloudService randomService = v0;
        if (randomService == null) {
            cloudPlayer.sendProperty("service.interact.no.free.service.found", new String[0]);
            return;
        }
        cloudPlayer.connect(randomService);
    }

    private final void handleInventory(Player player) {
        Bukkit.getScheduler().runTask((Plugin)this.serverNPCHandler.getNpcPlugin(), () -> AbstractServerNPC.handleInventory$lambda$10(player, this));
    }

    private static final void handleInventory$lambda$10(Player $player, AbstractServerNPC this$0) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        NPCPlugin.Companion.getInstance().getInventoryHandler().open($player, this$0.config.getTargetGroup());
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.QUICK_JOIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.OPEN_INVENTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.RUN_COMMAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

