/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.npc.plugin.npc.type;

import com.cryptomorin.xseries.XMaterial;
import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.InteractNpcEvent;
import com.github.juliarn.npclib.api.event.ShowNpcEvent;
import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.api.protocol.enums.EntityStatus;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.bukkit.util.BukkitPlatformUtil;
import com.github.juliarn.npclib.common.event.DefaultAttackNpcEvent;
import com.github.juliarn.npclib.common.event.DefaultInteractNpcEvent;
import eu.thesimplecloud.module.npc.lib.config.npc.CloudNPCData;
import eu.thesimplecloud.module.npc.lib.config.npc.LocationData;
import eu.thesimplecloud.module.npc.plugin.npc.ServerNPCHandler;
import eu.thesimplecloud.module.npc.plugin.npc.type.AbstractServerNPC;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0014R2\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Leu/thesimplecloud/module/npc/plugin/npc/type/PlayerNPC;", "Leu/thesimplecloud/module/npc/plugin/npc/type/AbstractServerNPC;", "serverNPCHandler", "Leu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler;", "config", "Leu/thesimplecloud/module/npc/lib/config/npc/CloudNPCData;", "(Leu/thesimplecloud/module/npc/plugin/npc/ServerNPCHandler;Leu/thesimplecloud/module/npc/lib/config/npc/CloudNPCData;)V", "npc", "Lcom/github/juliarn/npclib/api/Npc;", "Lorg/bukkit/World;", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/inventory/ItemStack;", "Lorg/bukkit/plugin/Plugin;", "getNpc", "()Lcom/github/juliarn/npclib/api/Npc;", "setNpc", "(Lcom/github/juliarn/npclib/api/Npc;)V", "getEntityHigh", "", "onDefaultAttackNpc", "", "event", "Lcom/github/juliarn/npclib/common/event/DefaultAttackNpcEvent;", "onDefaultInteractNpc", "Lcom/github/juliarn/npclib/common/event/DefaultInteractNpcEvent;", "onRemove", "onSetup", "onShowNpc", "Lcom/github/juliarn/npclib/api/event/ShowNpcEvent$Post;", "updateNPCStatus", "simplecloud-module-npc"})
public final class PlayerNPC
extends AbstractServerNPC {
    public Npc<World, Player, ItemStack, Plugin> npc;

    public PlayerNPC(@NotNull ServerNPCHandler serverNPCHandler, @NotNull CloudNPCData config) {
        Intrinsics.checkNotNullParameter((Object)serverNPCHandler, (String)"serverNPCHandler");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(serverNPCHandler, config);
    }

    @NotNull
    public final Npc<World, Player, ItemStack, Plugin> getNpc() {
        Npc<World, Player, ItemStack, Plugin> npc = this.npc;
        if (npc != null) {
            return npc;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"npc");
        return null;
    }

    public final void setNpc(@NotNull Npc<World, Player, ItemStack, Plugin> npc) {
        Intrinsics.checkNotNullParameter(npc, (String)"<set-?>");
        this.npc = npc;
    }

    @Override
    public void onSetup() {
        LocationData location = this.getConfig().getLocationData();
        this.setNpcLocation(new Location(Bukkit.getWorld((String)location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
        Position position = BukkitPlatformUtil.positionFromBukkitLegacy(this.getNpcLocation());
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"positionFromBukkitLegacy(this.npcLocation)");
        Position position2 = position;
        ProfileProperty profileProperty = ProfileProperty.property("textures", this.getConfig().getNpcSettings().getPlayerNPCData().getSkinData().getValue(), this.getConfig().getNpcSettings().getPlayerNPCData().getSkinData().getSignature());
        Intrinsics.checkNotNullExpressionValue((Object)profileProperty, (String)"property(\n            \"t\u2026nData.signature\n        )");
        ProfileProperty textures = profileProperty;
        Object[] objectArray = new ProfileProperty[]{textures};
        Npc<World, Player, ItemStack, Plugin> npc = ((Npc.Builder)((Npc.Builder)((Npc.Builder)this.getServerNPCHandler().getPlatform().newNpcBuilder().position(position2).flag(Npc.LOOK_AT_PLAYER, this.getConfig().getNpcSettings().getPlayerNPCData().getLookAtPlayer())).flag(Npc.HIT_WHEN_PLAYER_HITS, this.getConfig().getNpcSettings().getPlayerNPCData().getHitWhenPlayerHits())).flag(Npc.SNEAK_WHEN_PLAYER_SNEAKS, this.getConfig().getNpcSettings().getPlayerNPCData().getSneakWhenPlayerSneaks())).profile(Profile.resolved("SP-NPC-" + new Random().nextInt(9999999), UUID.randomUUID(), SetsKt.mutableSetOf((Object[])objectArray))).buildAndTrack();
        Intrinsics.checkNotNullExpressionValue(npc, (String)"this.serverNPCHandler.pl\u2026         .buildAndTrack()");
        this.setNpc(npc);
        this.getServerNPCHandler().getPlatform().eventBus().subscribe(DefaultInteractNpcEvent.class, arg_0 -> PlayerNPC.onSetup$lambda$0((Function1)new Function1<DefaultInteractNpcEvent, Unit>((Object)this){

            public final void invoke(@NotNull DefaultInteractNpcEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                PlayerNPC.access$onDefaultInteractNpc((PlayerNPC)this.receiver, p0);
            }
        }, arg_0));
        this.getServerNPCHandler().getPlatform().eventBus().subscribe(DefaultAttackNpcEvent.class, arg_0 -> PlayerNPC.onSetup$lambda$1((Function1)new Function1<DefaultAttackNpcEvent, Unit>((Object)this){

            public final void invoke(@NotNull DefaultAttackNpcEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                PlayerNPC.access$onDefaultAttackNpc((PlayerNPC)this.receiver, p0);
            }
        }, arg_0));
        this.getServerNPCHandler().getPlatform().eventBus().subscribe(ShowNpcEvent.Post.class, arg_0 -> PlayerNPC.onSetup$lambda$2((Function1)new Function1<ShowNpcEvent.Post, Unit>((Object)this){

            public final void invoke(@NotNull ShowNpcEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                PlayerNPC.access$onShowNpc((PlayerNPC)this.receiver, p0);
            }
        }, arg_0));
    }

    @Override
    public void onRemove() {
        this.getNpc().unlink();
    }

    public final void updateNPCStatus() {
        List entityStatuses = new ArrayList();
        if (this.getConfig().getNpcSettings().getGlowing()) {
            entityStatuses.add(EntityStatus.GLOWING);
        }
        if (this.getConfig().getNpcSettings().getPlayerNPCData().getFlyingWithElytra()) {
            entityStatuses.add(EntityStatus.FLYING_WITH_ELYTRA);
        }
        if (this.getConfig().getNpcSettings().getOnFire()) {
            entityStatuses.add(EntityStatus.ON_FIRE);
        }
        PlatformPacketAdapter<World, Player, ItemStack, Plugin> platformPacketAdapter = this.getNpc().platform().packetFactory();
        Intrinsics.checkNotNullExpressionValue(platformPacketAdapter, (String)"npc.platform().packetFactory()");
        PlatformPacketAdapter<World, Player, ItemStack, Plugin> packetFactory = platformPacketAdapter;
        packetFactory.createEntityMetaPacket(entityStatuses, EntityMetadataFactory.entityStatusMetaFactory()).scheduleForTracked(this.getNpc());
    }

    private final void onShowNpc(ShowNpcEvent.Post event) {
        PlatformPacketAdapter<World, Player, ItemStack, Plugin> platformPacketAdapter = this.getNpc().platform().packetFactory();
        Intrinsics.checkNotNullExpressionValue(platformPacketAdapter, (String)"npc.platform().packetFactory()");
        PlatformPacketAdapter<World, Player, ItemStack, Plugin> packetFactory = platformPacketAdapter;
        packetFactory.createEntityMetaPacket(true, EntityMetadataFactory.skinLayerMetaFactory()).scheduleForTracked(this.getNpc());
        this.updateNPCStatus();
        if (this.getConfig().getNpcItem().getRightHand() != null) {
            String string = this.getConfig().getNpcItem().getRightHand();
            Intrinsics.checkNotNull((Object)string);
            ItemStack itemStack = XMaterial.valueOf(string).parseItem();
            Intrinsics.checkNotNull((Object)itemStack);
            packetFactory.createEquipmentPacket(ItemSlot.MAIN_HAND, itemStack).scheduleForTracked(this.getNpc());
        }
        if (this.getConfig().getNpcItem().getLeftHand() != null) {
            String string = this.getConfig().getNpcItem().getLeftHand();
            Intrinsics.checkNotNull((Object)string);
            ItemStack itemStack = XMaterial.valueOf(string).parseItem();
            Intrinsics.checkNotNull((Object)itemStack);
            packetFactory.createEquipmentPacket(ItemSlot.OFF_HAND, itemStack).scheduleForTracked(this.getNpc());
        }
    }

    private final void onDefaultInteractNpc(DefaultInteractNpcEvent event) {
        Object p = event.player();
        Intrinsics.checkNotNullExpressionValue(p, (String)"event.player<Player>()");
        Player player = (Player)p;
        Npc npc = event.npc();
        Intrinsics.checkNotNullExpressionValue(npc, (String)"event.npc<World, Player, ItemStack, Plugin>()");
        Npc targetNpc = npc;
        if (event.hand() == InteractNpcEvent.Hand.OFF_HAND) {
            return;
        }
        if (this.getNpc().entityId() != targetNpc.entityId()) {
            return;
        }
        this.handlingInteract(player, true);
    }

    private final void onDefaultAttackNpc(DefaultAttackNpcEvent event) {
        Object p = event.player();
        Intrinsics.checkNotNullExpressionValue(p, (String)"event.player<Player>()");
        Player player = (Player)p;
        Npc npc = event.npc();
        Intrinsics.checkNotNullExpressionValue(npc, (String)"event.npc<World, Player, ItemStack, Plugin>()");
        Npc targetNpc = npc;
        if (this.getNpc().entityId() != targetNpc.entityId()) {
            return;
        }
        this.handlingInteract(player, false);
    }

    @Override
    public double getEntityHigh() {
        return 1.85;
    }

    private static final void onSetup$lambda$0(Function1 $tmp0, Object event) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(event);
    }

    private static final void onSetup$lambda$1(Function1 $tmp0, Object event) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(event);
    }

    private static final void onSetup$lambda$2(Function1 $tmp0, Object event) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(event);
    }

    public static final /* synthetic */ void access$onDefaultInteractNpc(PlayerNPC $this, DefaultInteractNpcEvent event) {
        $this.onDefaultInteractNpc(event);
    }

    public static final /* synthetic */ void access$onDefaultAttackNpc(PlayerNPC $this, DefaultAttackNpcEvent event) {
        $this.onDefaultAttackNpc(event);
    }

    public static final /* synthetic */ void access$onShowNpc(PlayerNPC $this, ShowNpcEvent.Post event) {
        $this.onShowNpc(event);
    }
}

