/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.event;

import java.util.function.Predicate;
import net.kyori.event.Cancellable;
import net.kyori.event.EventBusImpl;
import net.kyori.event.EventSubscriber;
import net.kyori.event.EventSubscription;
import net.kyori.event.PostResult;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface EventBus<E> {
    public static <E> @NonNull EventBus<E> create(@NonNull Class<E> type) {
        return EventBus.create(type, Accepts.nonCancelledWhenNotAcceptingCancelled());
    }

    public static <E> @NonNull EventBus<E> create(@NonNull Class<E> type, @NonNull Accepts<E> accepts) {
        return new EventBusImpl<E>(type, accepts);
    }

    public @NonNull Class<E> type();

    public @NonNull PostResult post(@NonNull E var1);

    public boolean subscribed(@NonNull Class<? extends E> var1);

    public <T extends E> @NonNull EventSubscription subscribe(@NonNull Class<T> var1, @NonNull EventSubscriber<? super T> var2);

    public void unsubscribeIf(@NonNull Predicate<EventSubscriber<? super E>> var1);

    public static interface Accepts<E> {
        public static <E> @NonNull Accepts<E> nonCancelledWhenNotAcceptingCancelled() {
            return (type, event, subscriber) -> subscriber.acceptsCancelled() || !(event instanceof Cancellable) || !((Cancellable)event).cancelled();
        }

        public boolean accepts(Class<E> var1, @NonNull E var2, @NonNull EventSubscriber<? super E> var3);
    }
}

