/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.event.EventSubscriber;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class PostResult {
    PostResult() {
        if (!(this instanceof Success) && !(this instanceof Failure)) {
            throw new IllegalStateException();
        }
    }

    public static @NonNull PostResult success() {
        return Success.INSTANCE;
    }

    public static @NonNull PostResult failure(@NonNull Map<EventSubscriber<?>, Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            throw new IllegalStateException("no exceptions present");
        }
        return new Failure(new HashMap(exceptions));
    }

    public abstract boolean wasSuccessful();

    public abstract @NonNull Map<EventSubscriber<?>, Throwable> exceptions();

    public abstract void raise() throws CompositeException;

    public abstract String toString();

    public static final class CompositeException
    extends Exception {
        private final PostResult result;

        CompositeException(@NonNull PostResult result) {
            super("Exceptions occurred whilst posting to subscribers");
            this.result = result;
        }

        public @NonNull PostResult result() {
            return this.result;
        }

        public void printAllStackTraces() {
            this.printStackTrace();
            for (Throwable exception : this.result.exceptions().values()) {
                exception.printStackTrace();
            }
        }
    }

    private static final class Failure
    extends PostResult {
        private final Map<EventSubscriber<?>, Throwable> exceptions;

        private Failure(@NonNull Map<EventSubscriber<?>, Throwable> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public boolean wasSuccessful() {
            return this.exceptions.isEmpty();
        }

        @Override
        public @NonNull Map<EventSubscriber<?>, Throwable> exceptions() {
            return this.exceptions;
        }

        @Override
        public void raise() throws CompositeException {
            throw new CompositeException(this);
        }

        @Override
        public String toString() {
            return "PostResult.failure(" + this.exceptions + ")";
        }
    }

    private static final class Success
    extends PostResult {
        static final Success INSTANCE = new Success();

        private Success() {
        }

        @Override
        public boolean wasSuccessful() {
            return true;
        }

        @Override
        public @NonNull Map<EventSubscriber<?>, Throwable> exceptions() {
            return Collections.emptyMap();
        }

        @Override
        public void raise() {
        }

        @Override
        public String toString() {
            return "PostResult.success()";
        }
    }
}

