/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.module.permission.PermissionPool;
import eu.thesimplecloud.module.permission.group.IPermissionGroup;
import eu.thesimplecloud.module.permission.player.IPermissionPlayer;
import eu.thesimplecloud.module.prefix.config.TablistInformation;
import eu.thesimplecloud.module.prefix.service.tablist.ProxyTablistHelper;
import eu.thesimplecloud.module.proxy.config.Config;
import eu.thesimplecloud.module.proxy.config.DefaultConfig;
import eu.thesimplecloud.module.proxy.config.ProxyGroupConfiguration;
import eu.thesimplecloud.module.proxy.config.TablistConfiguration;
import eu.thesimplecloud.module.proxy.extensions.ListExtensionKt;
import eu.thesimplecloud.module.proxy.service.ProxyHandler;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u000eJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010$\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&J\u001e\u0010$\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Leu/thesimplecloud/module/proxy/service/ProxyHandler;", "", "()V", "JOIN_FULL_PERMISSION", "", "JOIN_MAINTENANCE_PERMISSION", "configHolder", "Leu/thesimplecloud/api/property/IProperty;", "Leu/thesimplecloud/module/proxy/config/Config;", "getConfigHolder", "()Leu/thesimplecloud/api/property/IProperty;", "setConfigHolder", "(Leu/thesimplecloud/api/property/IProperty;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getCurrentTablistConfiguration", "Leu/thesimplecloud/module/proxy/config/TablistConfiguration;", "getHexColorComponent", "Lnet/kyori/adventure/text/TextComponent;", "message", "getOnlinePlayers", "getPermissionsGroupName", "uuid", "Ljava/util/UUID;", "getProxyConfiguration", "Leu/thesimplecloud/module/proxy/config/ProxyGroupConfiguration;", "getTabListConfigurations", "", "getTablistInformation", "Leu/thesimplecloud/module/prefix/config/TablistInformation;", "onEnable", "", "replaceString", "server", "Leu/thesimplecloud/api/service/ICloudService;", "simplecloud-module-proxy"})
public final class ProxyHandler {
    @NotNull
    public static final ProxyHandler INSTANCE = new ProxyHandler();
    @NotNull
    private static IProperty<Config> configHolder = (IProperty)new Property((Object)DefaultConfig.Companion.get());
    private static int index;
    @NotNull
    public static final String JOIN_MAINTENANCE_PERMISSION = "cloud.maintenance.join";
    @NotNull
    public static final String JOIN_FULL_PERMISSION = "cloud.full.join";

    private ProxyHandler() {
    }

    @NotNull
    public final IProperty<Config> getConfigHolder() {
        return configHolder;
    }

    public final void setConfigHolder(@NotNull IProperty<Config> iProperty) {
        Intrinsics.checkNotNullParameter(iProperty, (String)"<set-?>");
        configHolder = iProperty;
    }

    public final void onEnable() {
        CloudAPI.Companion.getInstance().getGlobalPropertyHolder().requestProperty("simplecloud-module-proxy-config").addResultListener((Function1)onEnable.1.INSTANCE);
    }

    public final int getIndex() {
        return index;
    }

    public final void setIndex(int n) {
        index = n;
    }

    @Nullable
    public final TablistConfiguration getCurrentTablistConfiguration() {
        List<TablistConfiguration> configurations = this.getTabListConfigurations();
        if (configurations.isEmpty()) {
            return null;
        }
        ProxyHandler proxyHandler = this;
        int n = index;
        if ((index = n + 1) >= configurations.size()) {
            index = 0;
        }
        return configurations.get(index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TablistConfiguration> getTabListConfigurations() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ((Config)configHolder.getValue()).getTablistConfigurations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TablistConfiguration it = (TablistConfiguration)element$iv$iv;
            boolean bl = false;
            List<String> list = ListExtensionKt.mapToLowerCase(it.getProxies());
            String string = CloudPlugin.Companion.getInstance().thisService().getGroupName();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (!list.contains(string3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ProxyGroupConfiguration getProxyConfiguration() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = ((Config)configHolder.getValue()).getProxyGroupConfigurations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProxyGroupConfiguration it = (ProxyGroupConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProxyGroup(), (Object)CloudPlugin.Companion.getInstance().thisService().getGroupName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final int getOnlinePlayers() {
        return CloudPlugin.Companion.getInstance().thisService().getServiceGroup().getOnlinePlayerCount();
    }

    @NotNull
    public final TextComponent getHexColorComponent(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ComponentLike[] componentLikeArray = new ComponentLike[]{(ComponentLike)MiniMessage.miniMessage().deserialize((Object)message)};
        TextComponent textComponent = Component.textOfChildren((ComponentLike[])componentLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"textOfChildren(MiniMessa\u2026e().deserialize(message))");
        return textComponent;
    }

    @NotNull
    public final String replaceString(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)message, (String)"%ONLINE_PLAYERS%", (String)String.valueOf(this.getOnlinePlayers()), (boolean)false, (int)4, null), (String)"%MAX_PLAYERS%", (String)String.valueOf(CloudPlugin.Companion.getInstance().thisService().getMaxPlayers()), (boolean)false, (int)4, null), (String)"%MAX_MEMORY%", (String)String.valueOf(CloudPlugin.Companion.getInstance().thisService().getMaxMemory()), (boolean)false, (int)4, null), (String)"%USED_MEMORY%", (String)String.valueOf(CloudPlugin.Companion.getInstance().thisService().getUsedMemory()), (boolean)false, (int)4, null), (String)"%PORT%", (String)String.valueOf(CloudPlugin.Companion.getInstance().thisService().getPort()), (boolean)false, (int)4, null), (String)"%PROXY%", (String)CloudPlugin.Companion.getInstance().thisService().getName(), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String replaceString(@NotNull String message, @NotNull ICloudService server) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)this.replaceString(message), (String)"%SERVER%", (String)server.getName(), (boolean)false, (int)4, null), (String)"%DISPLAYNAME%", (String)server.getDisplayName(), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String replaceString(@NotNull String message, @NotNull ICloudService server, @NotNull UUID uuid) {
        TablistInformation tablistInformation;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String replacedString = this.replaceString(message, server);
        String groupName = this.getPermissionsGroupName(uuid);
        if (groupName != null) {
            replacedString = StringsKt.replace$default((String)replacedString, (String)"%GROUP%", (String)groupName, (boolean)false, (int)4, null);
        }
        if ((tablistInformation = this.getTablistInformation(uuid)) == null) {
            return replacedString;
        }
        TablistInformation tablistInformation2 = tablistInformation;
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)replacedString, (String)"%COLOR%", (String)tablistInformation2.getColor(), (boolean)false, (int)4, null), (String)"%PRIORITY%", (String)String.valueOf(tablistInformation2.getPriority()), (boolean)false, (int)4, null), (String)"%PREFIX%", (String)tablistInformation2.getPrefix(), (boolean)false, (int)4, null), (String)"%SUFFIX%", (String)tablistInformation2.getSuffix(), (boolean)false, (int)4, null);
    }

    private final TablistInformation getTablistInformation(UUID uuid) {
        try {
            return ProxyTablistHelper.INSTANCE.getTablistInformationByUUID(uuid);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private final String getPermissionsGroupName(UUID uuid) {
        try {
            IPermissionPlayer iPermissionPlayer = PermissionPool.Companion.getInstance().getPermissionPlayerManager().getCachedPermissionPlayer(uuid);
            if (iPermissionPlayer == null) {
                return null;
            }
            IPermissionPlayer permissionPlayer = iPermissionPlayer;
            IPermissionGroup permissionGroup = permissionPlayer.getHighestPermissionGroup();
            return permissionGroup.getName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

