/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.service.bungee.listener;

import eu.thesimplecloud.module.proxy.config.Config;
import eu.thesimplecloud.module.proxy.config.MotdConfiguration;
import eu.thesimplecloud.module.proxy.config.ProxyGroupConfiguration;
import eu.thesimplecloud.module.proxy.config.TablistConfiguration;
import eu.thesimplecloud.module.proxy.extensions.ListExtensionKt;
import eu.thesimplecloud.module.proxy.service.ProxyHandler;
import eu.thesimplecloud.module.proxy.service.bungee.BungeePluginMain;
import eu.thesimplecloud.plugin.proxy.bungee.BungeeComponentExtensionsKt;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Leu/thesimplecloud/module/proxy/service/bungee/listener/BungeeListener;", "Lnet/md_5/bungee/api/plugin/Listener;", "plugin", "Leu/thesimplecloud/module/proxy/service/bungee/BungeePluginMain;", "(Leu/thesimplecloud/module/proxy/service/bungee/BungeePluginMain;)V", "on", "", "event", "Lnet/md_5/bungee/api/event/ProxyPingEvent;", "Lnet/md_5/bungee/api/event/ServerConnectEvent;", "Lnet/md_5/bungee/api/event/ServerConnectedEvent;", "Lnet/md_5/bungee/api/event/ServerSwitchEvent;", "simplecloud-module-proxy"})
public final class BungeeListener
implements Listener {
    @NotNull
    private final BungeePluginMain plugin;

    public BungeeListener(@NotNull BungeePluginMain plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=32)
    public final void on(@NotNull ServerConnectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer player = event.getPlayer();
        Config config = (Config)ProxyHandler.INSTANCE.getConfigHolder().getValue();
        Object object = ProxyHandler.INSTANCE.getProxyConfiguration();
        if (object == null) {
            return;
        }
        ProxyGroupConfiguration proxyConfiguration = object;
        if (CloudPlugin.Companion.getInstance().thisService().getServiceGroup().isInMaintenance() && !player.hasPermission("cloud.maintenance.join")) {
            List<String> list = ListExtensionKt.mapToLowerCase(proxyConfiguration.getWhitelist());
            object = player.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.name");
            boolean bl = false;
            String string = ((String)object).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            if (!list.contains(string)) {
                player.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)((Component)ProxyHandler.INSTANCE.getHexColorComponent(ProxyHandler.INSTANCE.replaceString(config.getMaintenanceKickMessage())))));
                event.setCancelled(true);
                return;
            }
        }
        int maxPlayers = CloudPlugin.Companion.getInstance().thisService().getServiceGroup().getMaxPlayers();
        if (ProxyHandler.INSTANCE.getOnlinePlayers() > maxPlayers && !player.hasPermission("cloud.full.join")) {
            List<String> list = ListExtensionKt.mapToLowerCase(proxyConfiguration.getWhitelist());
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.name");
            boolean bl = false;
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            if (!list.contains(string2)) {
                player.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)((Component)ProxyHandler.INSTANCE.getHexColorComponent(ProxyHandler.INSTANCE.replaceString(config.getFullProxyKickMessage())))));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public final void on(@NotNull ServerConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer player = event.getPlayer();
        TablistConfiguration tablistConfiguration = ProxyHandler.INSTANCE.getCurrentTablistConfiguration();
        if (tablistConfiguration == null) {
            return;
        }
        TablistConfiguration tablistConfiguration2 = tablistConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        this.plugin.sendHeaderAndFooter(player, tablistConfiguration2);
    }

    @EventHandler
    public final void on(@NotNull ServerSwitchEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer player = event.getPlayer();
        TablistConfiguration tablistConfiguration = ProxyHandler.INSTANCE.getCurrentTablistConfiguration();
        if (tablistConfiguration == null) {
            return;
        }
        TablistConfiguration tablistConfiguration2 = tablistConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        this.plugin.sendHeaderAndFooter(player, tablistConfiguration2);
    }

    @EventHandler
    public final void on(@NotNull ProxyPingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPing response = event.getResponse();
        ProxyGroupConfiguration proxyGroupConfiguration = ProxyHandler.INSTANCE.getProxyConfiguration();
        if (proxyGroupConfiguration == null) {
            return;
        }
        ProxyGroupConfiguration proxyConfiguration = proxyGroupConfiguration;
        MotdConfiguration motdConfiguration = CloudPlugin.Companion.getInstance().thisService().getServiceGroup().isInMaintenance() ? proxyConfiguration.getMaintenanceMotds() : proxyConfiguration.getMotds();
        Collection collection = motdConfiguration.getFirstLines();
        boolean bl = false;
        String line1 = (String)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default));
        Collection collection2 = motdConfiguration.getSecondLines();
        boolean bl2 = false;
        String line2 = (String)CollectionsKt.random((Collection)collection2, (Random)((Random)Random.Default));
        TextComponent motdComponent = ProxyHandler.INSTANCE.getHexColorComponent(ProxyHandler.INSTANCE.replaceString(line1 + '\n' + line2));
        response.setDescriptionComponent(BungeeComponentExtensionsKt.toBaseComponent((Component)((Component)motdComponent)));
        List<String> playerInfo = motdConfiguration.getPlayerInfo();
        int onlinePlayers = ProxyHandler.INSTANCE.getOnlinePlayers();
        String versionName = motdConfiguration.getVersionName();
        if (versionName != null) {
            CharSequence charSequence = versionName;
            boolean bl3 = false;
            if (charSequence.length() > 0) {
                TextComponent versionColorComponent = ProxyHandler.INSTANCE.getHexColorComponent(ProxyHandler.INSTANCE.replaceString(versionName));
                response.setVersion(new ServerPing.Protocol(LegacyComponentSerializer.legacy((char)'\u00a7').serialize((Component)versionColorComponent), -1));
            }
        }
        int maxPlayers = CloudPlugin.Companion.getInstance().thisService().getServiceGroup().getMaxPlayers();
        if (playerInfo != null) {
            Collection collection3 = playerInfo;
            boolean bl4 = false;
            if (!collection3.isEmpty()) {
                String playerInfoString = ProxyHandler.INSTANCE.replaceString(CollectionsKt.joinToString$default((Iterable)playerInfo, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                TextComponent playerInfoComponent = ProxyHandler.INSTANCE.getHexColorComponent(playerInfoString);
                ServerPing.PlayerInfo[] playerInfoArray = new ServerPing.PlayerInfo[]{new ServerPing.PlayerInfo(LegacyComponentSerializer.legacy((char)'\u00a7').serialize((Component)playerInfoComponent), "")};
                ServerPing.PlayerInfo[] sample = playerInfoArray;
                response.setPlayers(new ServerPing.Players(maxPlayers, onlinePlayers, sample));
                return;
            }
        }
        response.getPlayers().setMax(maxPlayers);
        response.getPlayers().setOnline(onlinePlayers);
    }
}

