/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.proxy.service.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.module.proxy.config.TablistConfiguration;
import eu.thesimplecloud.module.proxy.service.ProxyHandler;
import eu.thesimplecloud.module.proxy.service.velocity.listener.VelocityListener;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Plugin(id="simplecloud_proxy", dependencies={@Dependency(id="simplecloud_plugin")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/proxy/service/velocity/VelocityPluginMain;", "", "proxyServer", "Lcom/velocitypowered/api/proxy/ProxyServer;", "(Lcom/velocitypowered/api/proxy/ProxyServer;)V", "handleInit", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "sendHeaderAndFooter", "player", "Lcom/velocitypowered/api/proxy/Player;", "tablistConfiguration", "Leu/thesimplecloud/module/proxy/config/TablistConfiguration;", "header", "", "footer", "startScheduler", "simplecloud-module-proxy"})
public final class VelocityPluginMain {
    @NotNull
    private final ProxyServer proxyServer;

    @Inject
    public VelocityPluginMain(@NotNull ProxyServer proxyServer) {
        Intrinsics.checkNotNullParameter((Object)proxyServer, (String)"proxyServer");
        this.proxyServer = proxyServer;
    }

    @Subscribe
    public final void handleInit(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxyHandler.INSTANCE.onEnable();
        this.proxyServer.getEventManager().register((Object)this, (Object)new VelocityListener(this));
        this.startScheduler();
    }

    private final void startScheduler() {
        this.proxyServer.getScheduler().buildTask((Object)this, () -> VelocityPluginMain.startScheduler$lambda-1(this)).repeat(1L, TimeUnit.SECONDS).schedule();
    }

    public final void sendHeaderAndFooter(@NotNull Player player, @NotNull TablistConfiguration tablistConfiguration) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)tablistConfiguration, (String)"tablistConfiguration");
        String footerString = CollectionsKt.joinToString$default((Iterable)tablistConfiguration.getFooters(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String headerString = CollectionsKt.joinToString$default((Iterable)tablistConfiguration.getHeaders(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        this.sendHeaderAndFooter(player, headerString, footerString);
    }

    private final void sendHeaderAndFooter(Player player, String header, String footer) {
        ICloudService iCloudService = PlayerExtensionsKt.getCloudPlayer((Player)player).getConnectedServer();
        if (iCloudService == null) {
            return;
        }
        ICloudService server = iCloudService;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        TextComponent headerHexColorComponent = ProxyHandler.INSTANCE.getHexColorComponent(ProxyHandler.INSTANCE.replaceString(header, server, uUID));
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"player.uniqueId");
        TextComponent footerHexColorComponent = ProxyHandler.INSTANCE.getHexColorComponent(ProxyHandler.INSTANCE.replaceString(footer, server, uUID2));
        player.sendPlayerListHeaderAndFooter((Component)headerHexColorComponent, (Component)footerHexColorComponent);
    }

    private static final void startScheduler$lambda-1(VelocityPluginMain this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = ProxyHandler.INSTANCE.getCurrentTablistConfiguration();
        if (object == null) {
            return;
        }
        TablistConfiguration tablistConfiguration = object;
        object = this$0.proxyServer.getAllPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proxyServer.allPlayers");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this$0.sendHeaderAndFooter(it, tablistConfiguration);
        }
    }
}

