/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import eu.thesimplecloud.module.rest.auth.JwtProvider;
import eu.thesimplecloud.module.rest.auth.user.User;
import javalinjwt.JWTGenerator;
import javalinjwt.JWTProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/rest/auth/JwtProvider;", "", "secret", "", "(Ljava/lang/String;)V", "jwtAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "jwtGenerator", "Ljavalinjwt/JWTGenerator;", "Leu/thesimplecloud/module/rest/auth/user/User;", "kotlin.jvm.PlatformType", "jwtVerifier", "Lcom/auth0/jwt/JWTVerifier;", "provider", "Ljavalinjwt/JWTProvider;", "getProvider", "()Ljavalinjwt/JWTProvider;", "Companion", "simplecloud-module-rest"})
public final class JwtProvider {
    private final Algorithm jwtAlgorithm;
    private final JWTGenerator<User> jwtGenerator;
    private final JWTVerifier jwtVerifier;
    @NotNull
    private final JWTProvider provider;
    public static JwtProvider instance;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final JWTProvider getProvider() {
        return this.provider;
    }

    public JwtProvider(@NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Algorithm algorithm = Algorithm.HMAC512((String)secret);
        Intrinsics.checkNotNullExpressionValue((Object)algorithm, (String)"Algorithm.HMAC512(secret)");
        this.jwtAlgorithm = algorithm;
        this.jwtGenerator = jwtGenerator.1.INSTANCE;
        JWTVerifier jWTVerifier = JWT.require((Algorithm)this.jwtAlgorithm).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTVerifier, (String)"JWT.require(jwtAlgorithm).build()");
        this.jwtVerifier = jWTVerifier;
        this.provider = new JWTProvider(this.jwtAlgorithm, this.jwtGenerator, this.jwtVerifier);
        instance = this;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/module/rest/auth/JwtProvider$Companion;", "", "()V", "instance", "Leu/thesimplecloud/module/rest/auth/JwtProvider;", "getInstance", "()Leu/thesimplecloud/module/rest/auth/JwtProvider;", "setInstance", "(Leu/thesimplecloud/module/rest/auth/JwtProvider;)V", "simplecloud-module-rest"})
    public static final class Companion {
        @NotNull
        public final JwtProvider getInstance() {
            JwtProvider jwtProvider = instance;
            if (jwtProvider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            }
            return jwtProvider;
        }

        public final void setInstance(@NotNull JwtProvider jwtProvider) {
            Intrinsics.checkNotNullParameter((Object)jwtProvider, (String)"<set-?>");
            instance = jwtProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

