/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller.group;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudLobbyGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudProxyGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudServerGroup;
import eu.thesimplecloud.api.servicegroup.impl.DefaultLobbyGroup;
import eu.thesimplecloud.api.servicegroup.impl.DefaultProxyGroup;
import eu.thesimplecloud.api.servicegroup.impl.DefaultServerGroup;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.controller.IController;
import io.javalin.http.Context;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestController(path="cloud/group/")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014H\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0007J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014H\u0007J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a8\u0006!"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/group/ServiceGroupController;", "Leu/thesimplecloud/module/rest/controller/IController;", "()V", "doesGroupExist", "", "group", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "name", "", "getRegisteredGroupTypeClassByName", "Lkotlin/reflect/KClass;", "groupName", "handleCreateLobbyGroup", "Leu/thesimplecloud/api/servicegroup/impl/DefaultLobbyGroup;", "handleCreateProxyGroup", "Leu/thesimplecloud/api/servicegroup/impl/DefaultProxyGroup;", "handleCreateServerGroup", "Leu/thesimplecloud/api/servicegroup/impl/DefaultServerGroup;", "handleDeleteServiceGroup", "handleGetAllGroups", "", "handleGetLobbyGroups", "Leu/thesimplecloud/api/servicegroup/grouptype/ICloudLobbyGroup;", "handleGetOneGroup", "handleGetProxyGroups", "Leu/thesimplecloud/api/servicegroup/grouptype/ICloudProxyGroup;", "handleGetServerGroups", "Leu/thesimplecloud/api/servicegroup/grouptype/ICloudServerGroup;", "handleGetServicesOfGroup", "Leu/thesimplecloud/api/service/ICloudService;", "handleUpdateLobbyGroup", "ctx", "Lio/javalin/http/Context;", "simplecloud-module-rest"})
public final class ServiceGroupController
implements IController {
    @RequestMapping(requestType=RequestType.GET, additionalPath="", permission="web.cloud.group.get.all")
    @NotNull
    public final List<ICloudServiceGroup> handleGetAllGroups() {
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getAllCachedObjects();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="name/:name", permission="web.cloud.group.get.one")
    @Nullable
    public final ICloudServiceGroup handleGetOneGroup(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(name);
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="name/:name/services", permission="web.cloud.group.get.services")
    @NotNull
    public final List<ICloudService> handleGetServicesOfGroup(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServicesByGroupName(name);
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="lobby/", permission="web.cloud.group.get.type")
    @NotNull
    public final List<ICloudLobbyGroup> handleGetLobbyGroups() {
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getLobbyGroups();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="server/", permission="web.cloud.group.get.type")
    @NotNull
    public final List<ICloudServerGroup> handleGetServerGroups() {
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServerGroups();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="proxy/", permission="web.cloud.group.get.type")
    @NotNull
    public final List<ICloudProxyGroup> handleGetProxyGroups() {
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getProxyGroups();
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="lobby/", permission="web.cloud.group.create")
    public final boolean handleCreateLobbyGroup(@RequestBody @NotNull DefaultLobbyGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().createServiceGroup((ICloudServiceGroup)group).syncUninterruptibly().isSuccess();
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="server/", permission="web.cloud.group.create")
    public final boolean handleCreateServerGroup(@RequestBody @NotNull DefaultServerGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().createServiceGroup((ICloudServiceGroup)group).syncUninterruptibly().isSuccess();
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="proxy/", permission="web.cloud.group.create")
    public final boolean handleCreateProxyGroup(@RequestBody @NotNull DefaultProxyGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().createServiceGroup((ICloudServiceGroup)group).syncUninterruptibly().isSuccess();
    }

    @RequestMapping(requestType=RequestType.PUT, additionalPath="", permission="web.cloud.group.update")
    public final boolean handleUpdateLobbyGroup(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        JsonLib jsonLib = JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)ctx.body(), null, (int)2, null);
        String string = jsonLib.getString("name");
        if (string == null) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        String groupName = string;
        if (!this.doesGroupExist(groupName)) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        KClass<? extends ICloudServiceGroup> groupClass = this.getRegisteredGroupTypeClassByName(groupName);
        ICloudServiceGroup updateGroup = (ICloudServiceGroup)jsonLib.getObject(JvmClassMappingKt.getJavaClass(groupClass));
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceGroupManager()), (Object)updateGroup, (boolean)false, (boolean)false, (int)6, null);
        return true;
    }

    @RequestMapping(requestType=RequestType.DELETE, additionalPath="name/:name", permission="web.cloud.group.delete")
    public final boolean handleDeleteServiceGroup(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.doesGroupExist(name)) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICloudServiceGroup iCloudServiceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(name);
        Intrinsics.checkNotNull((Object)iCloudServiceGroup);
        ICloudServiceGroup group = iCloudServiceGroup;
        ICacheList.DefaultImpls.delete$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getCloudServiceGroupManager()), (Object)group, (boolean)false, (int)2, null);
        return true;
    }

    private final KClass<? extends ICloudServiceGroup> getRegisteredGroupTypeClassByName(String groupName) {
        ICloudServiceGroup iCloudServiceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(groupName);
        Intrinsics.checkNotNull((Object)iCloudServiceGroup);
        return Reflection.getOrCreateKotlinClass(iCloudServiceGroup.getClass());
    }

    private final boolean doesGroupExist(ICloudServiceGroup group) {
        return this.doesGroupExist(group.getName());
    }

    private final boolean doesGroupExist(String name) {
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(name) != null;
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }
}

