/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller.wrapper;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.api.wrapper.impl.DefaultWrapperInfo;
import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.controller.IController;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestController(path="cloud/wrapper/")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/wrapper/WrapperController;", "Leu/thesimplecloud/module/rest/controller/IController;", "()V", "doesWrapperExist", "", "name", "", "getWrapperByName", "Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "handleCreateWrapper", "wrapper", "Leu/thesimplecloud/api/wrapper/impl/DefaultWrapperInfo;", "handleDeleteWrapper", "handleGetAllWrappers", "", "handleGetOneWrapper", "handleUpdateWrapper", "simplecloud-module-rest"})
public final class WrapperController
implements IController {
    @RequestMapping(requestType=RequestType.GET, additionalPath="", permission="web.cloud.wrapper.get.all")
    @NotNull
    public final List<IWrapperInfo> handleGetAllWrappers() {
        return CloudAPI.Companion.getInstance().getWrapperManager().getAllCachedObjects();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="name/:name/", permission="web.cloud.wrapper.get.one")
    @Nullable
    public final IWrapperInfo handleGetOneWrapper(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getWrapperByName(name);
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="", permission="web.cloud.wrapper.create")
    @NotNull
    public final IWrapperInfo handleCreateWrapper(@RequestBody @NotNull DefaultWrapperInfo wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (this.doesWrapperExist(wrapper.getName())) {
            Void void_ = this.throwElementAlreadyExist();
            throw new KotlinNothingValueException();
        }
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getWrapperManager()), (Object)wrapper, (boolean)false, (boolean)false, (int)6, null);
        return (IWrapperInfo)wrapper;
    }

    @RequestMapping(requestType=RequestType.PUT, additionalPath="", permission="web.cloud.wrapper.update")
    @Nullable
    public final IWrapperInfo handleUpdateWrapper(@RequestBody @NotNull DefaultWrapperInfo wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (!this.doesWrapperExist(wrapper.getName())) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getWrapperManager()), (Object)wrapper, (boolean)false, (boolean)false, (int)6, null);
        return (IWrapperInfo)wrapper;
    }

    @RequestMapping(requestType=RequestType.DELETE, additionalPath="name/:name", permission="web.cloud.wrapper.delete")
    @Nullable
    public final IWrapperInfo handleDeleteWrapper(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.doesWrapperExist(name)) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        IWrapperInfo iWrapperInfo = this.getWrapperByName(name);
        Intrinsics.checkNotNull((Object)iWrapperInfo);
        IWrapperInfo wrapper = iWrapperInfo;
        ICacheList.DefaultImpls.delete$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getWrapperManager()), (Object)wrapper, (boolean)false, (int)2, null);
        return wrapper;
    }

    private final IWrapperInfo getWrapperByName(String name) {
        return CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByName(name);
    }

    private final boolean doesWrapperExist(String name) {
        return this.getWrapperByName(name) != null;
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }
}

