/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.controller.IController;
import eu.thesimplecloud.module.rest.defaultcontroller.dto.CommandDto;
import eu.thesimplecloud.module.rest.defaultcontroller.dto.PathDto;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RestController(path="cloud/action/service/")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/service/ServiceActionController;", "Leu/thesimplecloud/module/rest/controller/IController;", "()V", "getServiceByName", "Leu/thesimplecloud/api/service/ICloudService;", "name", "", "handleCommandExecute", "command", "Leu/thesimplecloud/module/rest/defaultcontroller/dto/CommandDto;", "handleCopyService", "path", "Leu/thesimplecloud/module/rest/defaultcontroller/dto/PathDto;", "handleServiceStop", "simplecloud-module-rest"})
public final class ServiceActionController
implements IController {
    @RequestMapping(requestType=RequestType.POST, additionalPath="name/:name/shutdown", permission="web.cloud.action.service.shutdown")
    @NotNull
    public final ICloudService handleServiceStop(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ICloudService iCloudService = this.getServiceByName(name);
        if (iCloudService == null) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICloudService service = iCloudService;
        service.shutdown();
        return service;
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="name/:name/copy", permission="web.cloud.action.service.copy")
    @NotNull
    public final ICloudService handleCopyService(@RequestPathParam(parameterName="name") @NotNull String name, @RequestBody @NotNull PathDto path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ICloudService iCloudService = this.getServiceByName(name);
        if (iCloudService == null) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICloudService service = iCloudService;
        service.copy(path.getPath());
        return service;
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="name/:name/execute", permission="web.cloud.action.service.execute")
    @NotNull
    public final ICloudService handleCommandExecute(@RequestPathParam(parameterName="name") @NotNull String name, @RequestBody @NotNull CommandDto command) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        ICloudService iCloudService = this.getServiceByName(name);
        if (iCloudService == null) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICloudService service = iCloudService;
        service.executeCommand(command.getCommand());
        return service;
    }

    private final ICloudService getServiceByName(String name) {
        return CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(name);
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }
}

