/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.rest.defaultcontroller.template;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.template.ITemplate;
import eu.thesimplecloud.api.template.impl.DefaultTemplate;
import eu.thesimplecloud.module.rest.annotation.RequestBody;
import eu.thesimplecloud.module.rest.annotation.RequestMapping;
import eu.thesimplecloud.module.rest.annotation.RequestPathParam;
import eu.thesimplecloud.module.rest.annotation.RequestType;
import eu.thesimplecloud.module.rest.annotation.RestController;
import eu.thesimplecloud.module.rest.controller.IController;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RestController(path="cloud/template/")
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u0012\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/module/rest/defaultcontroller/template/TemplateController;", "Leu/thesimplecloud/module/rest/controller/IController;", "()V", "doesTemplateExist", "", "name", "", "handleCreateTemplate", "Leu/thesimplecloud/api/template/ITemplate;", "template", "Leu/thesimplecloud/api/template/impl/DefaultTemplate;", "handleDeleteTemplate", "handleGetAllTemplates", "", "handleGetOneTemplates", "handleUpdateTemplate", "simplecloud-module-rest"})
public final class TemplateController
implements IController {
    @RequestMapping(requestType=RequestType.GET, additionalPath="", permission="web.cloud.template.get.all")
    @NotNull
    public final List<ITemplate> handleGetAllTemplates() {
        return CloudAPI.Companion.getInstance().getTemplateManager().getAllCachedObjects();
    }

    @RequestMapping(requestType=RequestType.GET, additionalPath="name/:name/", permission="web.cloud.template.get.one")
    @NotNull
    public final ITemplate handleGetOneTemplates(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ITemplate iTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName(name);
        if (iTemplate == null) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        return iTemplate;
    }

    @RequestMapping(requestType=RequestType.POST, additionalPath="", permission="web.cloud.template.create")
    @NotNull
    public final ITemplate handleCreateTemplate(@RequestBody @NotNull DefaultTemplate template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (this.doesTemplateExist(template.getName())) {
            Void void_ = this.throwElementAlreadyExist();
            throw new KotlinNothingValueException();
        }
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getTemplateManager()), (Object)template, (boolean)false, (boolean)false, (int)6, null);
        return (ITemplate)template;
    }

    @RequestMapping(requestType=RequestType.PUT, additionalPath="", permission="web.cloud.template.update")
    @NotNull
    public final ITemplate handleUpdateTemplate(@RequestBody @NotNull DefaultTemplate template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (!this.doesTemplateExist(template.getName())) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ICacheList.DefaultImpls.update$default((ICacheList)((ICacheList)CloudAPI.Companion.getInstance().getTemplateManager()), (Object)template, (boolean)false, (boolean)false, (int)6, null);
        return (ITemplate)template;
    }

    @RequestMapping(requestType=RequestType.DELETE, additionalPath="name/:name", permission="web.cloud.template.delete")
    @NotNull
    public final ITemplate handleDeleteTemplate(@RequestPathParam(parameterName="name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.doesTemplateExist(name)) {
            Void void_ = this.throwNoSuchElement();
            throw new KotlinNothingValueException();
        }
        ITemplate iTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName(name);
        Intrinsics.checkNotNull((Object)iTemplate);
        ITemplate template = iTemplate;
        CloudAPI.Companion.getInstance().getTemplateManager().deleteTemplate(name);
        return template;
    }

    private final boolean doesTemplateExist(String name) {
        return CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName(name) != null;
    }

    @Override
    @NotNull
    public Void throwElementAlreadyExist() {
        return IController.DefaultImpls.throwElementAlreadyExist(this);
    }

    @Override
    @NotNull
    public Void throwNoSuchElement() {
        return IController.DefaultImpls.throwNoSuchElement(this);
    }
}

