/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.lib.layout;

import eu.thesimplecloud.api.utils.Nameable;
import eu.thesimplecloud.jsonlib.JsonLibExclude;
import eu.thesimplecloud.module.sign.lib.layout.LayoutType;
import eu.thesimplecloud.module.sign.lib.layout.SignFrame;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0006\u0010\u0010\u001a\u00020\u0011R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/module/sign/lib/layout/SignLayout;", "Leu/thesimplecloud/api/utils/Nameable;", "name", "", "layoutType", "Leu/thesimplecloud/module/sign/lib/layout/LayoutType;", "frames", "", "Leu/thesimplecloud/module/sign/lib/layout/SignFrame;", "(Ljava/lang/String;Leu/thesimplecloud/module/sign/lib/layout/LayoutType;Ljava/util/List;)V", "currentFrameIndex", "", "getLayoutType", "()Leu/thesimplecloud/module/sign/lib/layout/LayoutType;", "getCurrentFrame", "getName", "nextFrame", "", "simplecloud-module-sign"})
public final class SignLayout
implements Nameable {
    @NotNull
    private final String name;
    @NotNull
    private final LayoutType layoutType;
    @NotNull
    private final List<SignFrame> frames;
    @JsonLibExclude
    private int currentFrameIndex;

    public SignLayout(@NotNull String name, @NotNull LayoutType layoutType, @NotNull List<SignFrame> frames) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutType), (String)"layoutType");
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        this.name = name;
        this.layoutType = layoutType;
        this.frames = frames;
    }

    @NotNull
    public final LayoutType getLayoutType() {
        return this.layoutType;
    }

    @NotNull
    public final SignFrame getCurrentFrame() {
        SignFrame signFrame = (SignFrame)CollectionsKt.getOrNull(this.frames, (int)this.currentFrameIndex);
        if (signFrame == null) {
            String[] stringArray = new String[]{"", "empty layout", "", ""};
            SignFrame signFrame2 = new SignFrame(stringArray);
            signFrame = signFrame2;
        }
        return signFrame;
    }

    public final void nextFrame() {
        int n = this.currentFrameIndex;
        this.currentFrameIndex = n + 1;
        if (this.currentFrameIndex > this.frames.size() - 1) {
            this.currentFrameIndex = 0;
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

