/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.manager;

import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.sign.lib.SignModuleConfig;
import eu.thesimplecloud.module.sign.lib.group.GroupLayoutsContainer;
import eu.thesimplecloud.module.sign.lib.layout.LayoutType;
import eu.thesimplecloud.module.sign.lib.layout.SignFrame;
import eu.thesimplecloud.module.sign.lib.layout.SignLayout;
import eu.thesimplecloud.module.sign.lib.layout.SignLayoutContainer;
import eu.thesimplecloud.module.sign.lib.settings.CloudSignSettingsContainer;
import eu.thesimplecloud.module.sign.lib.sign.CloudSignContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/module/sign/manager/SignModuleConfigPersistence;", "", "()V", "groupLayoutsFile", "Ljava/io/File;", "layoutsDir", "signSettingsFile", "signsFile", "createDefaultConfig", "Leu/thesimplecloud/module/sign/lib/SignModuleConfig;", "getDefaultLayoutList", "", "Leu/thesimplecloud/module/sign/lib/layout/SignLayout;", "getLayoutsDirectoryByLayoutType", "layoutType", "Leu/thesimplecloud/module/sign/lib/layout/LayoutType;", "load", "save", "", "signModuleConfig", "simplecloud-module-sign"})
@SourceDebugExtension(value={"SMAP\nSignModuleConfigPersistence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignModuleConfigPersistence.kt\neu/thesimplecloud/module/sign/manager/SignModuleConfigPersistence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,130:1\n1855#2,2:131\n1549#2:137\n1620#2,3:138\n1549#2:141\n1620#2,3:142\n11335#3:133\n11670#3,3:134\n*S KotlinDebug\n*F\n+ 1 SignModuleConfigPersistence.kt\neu/thesimplecloud/module/sign/manager/SignModuleConfigPersistence\n*L\n56#1:131,2\n77#1:137\n77#1:138,3\n79#1:141\n79#1:142,3\n76#1:133\n76#1:134,3\n*E\n"})
public final class SignModuleConfigPersistence {
    @NotNull
    public static final SignModuleConfigPersistence INSTANCE = new SignModuleConfigPersistence();
    @NotNull
    private static final File layoutsDir = new File("modules/sign/layouts/");
    @NotNull
    private static final File signsFile = new File("modules/sign/signs.json");
    @NotNull
    private static final File signSettingsFile = new File("modules/sign/signSettings.json");
    @NotNull
    private static final File groupLayoutsFile = new File("modules/sign/groupLayouts.json");

    private SignModuleConfigPersistence() {
    }

    public final void save(@NotNull SignModuleConfig signModuleConfig) {
        Intrinsics.checkNotNullParameter((Object)signModuleConfig, (String)"signModuleConfig");
        JsonLib.Companion.fromObject((Object)signModuleConfig.getGroupsLayoutContainer()).saveAsFile(groupLayoutsFile);
        JsonLib.Companion.fromObject((Object)signModuleConfig.getSignContainer()).saveAsFile(signsFile);
        JsonLib.Companion.fromObject((Object)signModuleConfig.getCloudSignSettingsContainer()).saveAsFile(signSettingsFile);
        List<SignLayout> allLayouts = signModuleConfig.getSignLayoutContainer().getAllLayouts();
        Iterable $this$forEach$iv = allLayouts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SignLayout it = (SignLayout)element$iv;
            boolean bl = false;
            File dir = INSTANCE.getLayoutsDirectoryByLayoutType(it.getLayoutType());
            JsonLib.Companion.fromObject((Object)it).saveAsFile(new File(dir, it.getName() + ".json"));
        }
    }

    private final File getLayoutsDirectoryByLayoutType(LayoutType layoutType) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = layoutType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return new File(layoutsDir, stringBuilder.append(string).append('/').toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SignModuleConfig load() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        File it;
        Collection collection;
        void $this$mapTo$iv$iv3;
        if (!groupLayoutsFile.exists()) {
            return this.createDefaultConfig();
        }
        if (!signsFile.exists()) {
            return this.createDefaultConfig();
        }
        if (!signSettingsFile.exists()) {
            return this.createDefaultConfig();
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)groupLayoutsFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        GroupLayoutsContainer groupsLayoutContainer = (GroupLayoutsContainer)jsonLib.getObject(GroupLayoutsContainer.class);
        JsonLib jsonLib2 = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)signsFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib2);
        CloudSignContainer cloudSignContainer = (CloudSignContainer)jsonLib2.getObject(CloudSignContainer.class);
        JsonLib jsonLib3 = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)signSettingsFile, null, (int)2, null);
        Intrinsics.checkNotNull((Object)jsonLib3);
        CloudSignSettingsContainer cloudSignSettingsContainer = (CloudSignSettingsContainer)jsonLib3.getObject(CloudSignSettingsContainer.class);
        LayoutType[] $this$map$iv = LayoutType.values();
        boolean $i$f$map = false;
        LayoutType[] layoutTypeArray = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void var13_20 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.getLayoutsDirectoryByLayoutType((LayoutType)((Object)it)));
        }
        List allLayoutDirectories = (List)destination$iv$iv;
        Iterable $this$map$iv2 = allLayoutDirectories;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            File[] fileArray = it.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"it.listFiles()");
            collection.add(ArraysKt.toList((Object[])fileArray));
        }
        List allFiles = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = allFiles;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            File bl = (File)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            JsonLib jsonLib4 = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)it2, null, (int)2, null);
            Intrinsics.checkNotNull((Object)jsonLib4);
            collection.add((SignLayout)jsonLib4.getObject(SignLayout.class));
        }
        List layouts = (List)destination$iv$iv3;
        return new SignModuleConfig(new SignLayoutContainer(CollectionsKt.toMutableList((Collection)layouts)), cloudSignContainer, groupsLayoutContainer, cloudSignSettingsContainer);
    }

    private final SignModuleConfig createDefaultConfig() {
        GroupLayoutsContainer groupsLayoutContainer = new GroupLayoutsContainer();
        CloudSignContainer cloudSignContainer = new CloudSignContainer();
        SignLayoutContainer layoutsContainer = new SignLayoutContainer(CollectionsKt.toMutableList((Collection)this.getDefaultLayoutList()));
        CloudSignSettingsContainer cloudSignSettingsContainer = new CloudSignSettingsContainer(20L);
        return new SignModuleConfig(layoutsContainer, cloudSignContainer, groupsLayoutContainer, cloudSignSettingsContainer);
    }

    private final List<SignLayout> getDefaultLayoutList() {
        Object[] objectArray = new SignLayout[5];
        Object[] objectArray2 = new SignFrame[3];
        String[] stringArray = new String[]{"\u00a78--------", "Searching for", "server.", "\u00a78--------"};
        objectArray2[0] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a78--------", "Searching for", "server..", "\u00a78--------"};
        objectArray2[1] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a78--------", "Searching for", "server...", "\u00a78--------"};
        objectArray2[2] = new SignFrame(stringArray);
        objectArray[0] = new SignLayout("default", LayoutType.SEARCHING, CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new SignFrame[3];
        stringArray = new String[]{"\u00a76--------", "Server is", "starting.", "\u00a76--------"};
        objectArray2[0] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a76--------", "Server is", "starting..", "\u00a76--------"};
        objectArray2[1] = new SignFrame(stringArray);
        stringArray = new String[]{"\u00a76--------", "Server is", "starting...", "\u00a76--------"};
        objectArray2[2] = new SignFrame(stringArray);
        objectArray[1] = new SignLayout("default", LayoutType.STARTING, CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"\u00a74--------", "%GROUP%", "\u00a78Maintenance", "\u00a74--------"};
        objectArray[2] = new SignLayout("default", LayoutType.MAINTENANCE, CollectionsKt.listOf((Object)new SignFrame((String[])objectArray2)));
        objectArray2 = new String[]{"%DISPLAYNAME%", "\u00a7a%STATE%", "%MOTD%", "%ONLINE_PLAYERS%/%MAX_PLAYERS%"};
        objectArray[3] = new SignLayout("default", LayoutType.ONLINE, CollectionsKt.listOf((Object)new SignFrame((String[])objectArray2)));
        objectArray2 = new String[]{"%DISPLAYNAME%", "\u00a76%STATE%", "%MOTD%", "%ONLINE_PLAYERS%/%MAX_PLAYERS%"};
        objectArray[4] = new SignLayout("default", LayoutType.FULL, CollectionsKt.listOf((Object)new SignFrame((String[])objectArray2)));
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

