/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.serviceselection.api.AbstractServiceViewer;
import eu.thesimplecloud.module.sign.lib.SignModuleConfig;
import eu.thesimplecloud.module.sign.lib.layout.LayoutType;
import eu.thesimplecloud.module.sign.lib.layout.SignFrame;
import eu.thesimplecloud.module.sign.lib.layout.SignLayout;
import eu.thesimplecloud.module.sign.lib.sign.CloudSign;
import eu.thesimplecloud.module.sign.service.BukkitCloudSign;
import eu.thesimplecloud.module.sign.service.Placeholder;
import eu.thesimplecloud.module.sign.service.event.BukkitCloudSignUpdatedEvent;
import eu.thesimplecloud.plugin.extension.LocationExtensionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Leu/thesimplecloud/module/sign/service/BukkitCloudSign;", "Leu/thesimplecloud/module/serviceselection/api/AbstractServiceViewer;", "cloudSign", "Leu/thesimplecloud/module/sign/lib/sign/CloudSign;", "(Leu/thesimplecloud/module/sign/lib/sign/CloudSign;)V", "getCloudSign", "()Leu/thesimplecloud/module/sign/lib/sign/CloudSign;", "location", "Lorg/bukkit/Location;", "getLocation", "()Lorg/bukkit/Location;", "serviceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "getServiceGroup", "()Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "calculateLayoutType", "Leu/thesimplecloud/module/sign/lib/layout/LayoutType;", "clearSign", "", "update", "", "removeView", "replacePlaceholders", "", "lineToReplace", "currentServer", "Leu/thesimplecloud/api/service/ICloudService;", "updateView", "Companion", "simplecloud-module-sign"})
@SourceDebugExtension(value={"SMAP\nBukkitCloudSign.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BukkitCloudSign.kt\neu/thesimplecloud/module/sign/service/BukkitCloudSign\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1855#2,2:136\n1855#2,2:138\n*S KotlinDebug\n*F\n+ 1 BukkitCloudSign.kt\neu/thesimplecloud/module/sign/service/BukkitCloudSign\n*L\n85#1:136,2\n86#1:138,2\n*E\n"})
public final class BukkitCloudSign
extends AbstractServiceViewer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSign cloudSign;
    @Nullable
    private final ICloudServiceGroup serviceGroup;
    @Nullable
    private final Location location;
    @NotNull
    private static final List<Placeholder<ICloudService>> PLACEHOLDERS;
    @NotNull
    private static final List<Placeholder<ICloudServiceGroup>> GROUP_PLACEHOLDERS;

    public BukkitCloudSign(@NotNull CloudSign cloudSign) {
        Intrinsics.checkNotNullParameter((Object)cloudSign, (String)"cloudSign");
        this.cloudSign = cloudSign;
        this.serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(this.cloudSign.getForGroup());
        this.location = LocationExtensionKt.toBukkitLocation((SimpleLocation)((SimpleLocation)this.cloudSign.getTemplateLocation()));
    }

    @NotNull
    public final CloudSign getCloudSign() {
        return this.cloudSign;
    }

    @Nullable
    public final ICloudServiceGroup getServiceGroup() {
        return this.serviceGroup;
    }

    @Nullable
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public void updateView() {
        if (this.serviceGroup == null) {
            System.out.println((Object)("[SimpleCloud-Sign] WARNING: Cannot find group by name: " + this.cloudSign.getForGroup()));
            return;
        }
        if (this.location == null) {
            System.out.println((Object)("[SimpleCloud-Sign] WARNING: Cannot find world by name: " + this.cloudSign.getTemplateLocation().getWorldName()));
            return;
        }
        if (!this.location.getChunk().isLoaded()) {
            return;
        }
        if (!(this.location.getBlock().getState() instanceof Sign)) {
            return;
        }
        ICloudService currentServer = this.getService();
        BlockState blockState = this.location.getBlock().getState();
        Intrinsics.checkNotNull((Object)blockState, (String)"null cannot be cast to non-null type org.bukkit.block.Sign");
        Sign sign = (Sign)blockState;
        this.clearSign(false);
        SignModuleConfig config = SignModuleConfig.Companion.getConfig();
        LayoutType layoutType = this.calculateLayoutType();
        SignLayout signLayout = config.getSignLayoutForGroup(layoutType, this.serviceGroup.getName());
        SignFrame currentFrame = signLayout.getCurrentFrame();
        for (int i = 0; i < 4; ++i) {
            sign.setLine(i, this.replacePlaceholders(currentFrame.getLines()[i], currentServer));
        }
        sign.update();
        IEventManager.DefaultImpls.call$default((IEventManager)CloudAPI.Companion.getInstance().getEventManager(), (IEvent)new BukkitCloudSignUpdatedEvent(this), (boolean)false, (int)2, null);
    }

    private final String replacePlaceholders(String lineToReplace, ICloudService currentServer) {
        Placeholder it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        String lineToReplace2 = null;
        lineToReplace2 = lineToReplace;
        if (currentServer != null) {
            $this$forEach$iv = PLACEHOLDERS;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Placeholder)element$iv;
                boolean bl = false;
                lineToReplace2 = it.replacePlaceholder(currentServer, lineToReplace2);
            }
        }
        $this$forEach$iv = GROUP_PLACEHOLDERS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Placeholder)element$iv;
            boolean bl = false;
            ICloudServiceGroup iCloudServiceGroup = this.serviceGroup;
            Intrinsics.checkNotNull((Object)iCloudServiceGroup);
            lineToReplace2 = it.replacePlaceholder(iCloudServiceGroup, lineToReplace2);
        }
        return lineToReplace2;
    }

    private final LayoutType calculateLayoutType() {
        ICloudServiceGroup iCloudServiceGroup = this.serviceGroup;
        Intrinsics.checkNotNull((Object)iCloudServiceGroup);
        if (iCloudServiceGroup.isInMaintenance()) {
            return LayoutType.MAINTENANCE;
        }
        if (this.getService() == null) {
            return LayoutType.SEARCHING;
        }
        ICloudService iCloudService = this.getService();
        Intrinsics.checkNotNull((Object)iCloudService);
        if (iCloudService.getState() == ServiceState.STARTING) {
            return LayoutType.STARTING;
        }
        ICloudService iCloudService2 = this.getService();
        Intrinsics.checkNotNull((Object)iCloudService2);
        if (iCloudService2.getState() != ServiceState.VISIBLE) {
            return LayoutType.SEARCHING;
        }
        ICloudService iCloudService3 = this.getService();
        Intrinsics.checkNotNull((Object)iCloudService3);
        if (iCloudService3.isFull()) {
            return LayoutType.FULL;
        }
        return LayoutType.ONLINE;
    }

    @Override
    public void removeView() {
        this.clearSign(true);
    }

    private final void clearSign(boolean update) {
        Location location = this.location;
        Intrinsics.checkNotNull((Object)location);
        Location location2 = location;
        if (location2.getBlock().getState() instanceof Sign) {
            BlockState blockState = location2.getBlock().getState();
            Intrinsics.checkNotNull((Object)blockState, (String)"null cannot be cast to non-null type org.bukkit.block.Sign");
            Sign sign = (Sign)blockState;
            for (int i = 0; i < 4; ++i) {
                sign.setLine(i, "");
            }
            if (update) {
                sign.update();
            }
        }
    }

    static /* synthetic */ void clearSign$default(BukkitCloudSign bukkitCloudSign, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        bukkitCloudSign.clearSign(bl);
    }

    static {
        Object[] objectArray = new Placeholder[]{new Placeholder("SERVICE", Companion.PLACEHOLDERS.1.INSTANCE), new Placeholder("ONLINE_PLAYERS", Companion.PLACEHOLDERS.2.INSTANCE), new Placeholder("ONLINE_COUNT", Companion.PLACEHOLDERS.3.INSTANCE), new Placeholder("MOTD", Companion.PLACEHOLDERS.4.INSTANCE), new Placeholder("HOST", Companion.PLACEHOLDERS.5.INSTANCE), new Placeholder("PORT", Companion.PLACEHOLDERS.6.INSTANCE), new Placeholder("STATE", Companion.PLACEHOLDERS.7.INSTANCE), new Placeholder("NUMBER", Companion.PLACEHOLDERS.8.INSTANCE), new Placeholder("WRAPPER", Companion.PLACEHOLDERS.9.INSTANCE), new Placeholder("MAX_PLAYERS", Companion.PLACEHOLDERS.10.INSTANCE), new Placeholder("DISPLAYNAME", Companion.PLACEHOLDERS.11.INSTANCE)};
        PLACEHOLDERS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Placeholder[]{new Placeholder("GROUP", Companion.GROUP_PLACEHOLDERS.1.INSTANCE), new Placeholder("TEMPLATE", Companion.GROUP_PLACEHOLDERS.2.INSTANCE)};
        GROUP_PLACEHOLDERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/module/sign/service/BukkitCloudSign$Companion;", "", "()V", "GROUP_PLACEHOLDERS", "", "Leu/thesimplecloud/module/sign/service/Placeholder;", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "PLACEHOLDERS", "Leu/thesimplecloud/api/service/ICloudService;", "simplecloud-module-sign"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

