/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.sign.service.command;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.location.TemplateLocation;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.module.sign.lib.SignModuleConfig;
import eu.thesimplecloud.module.sign.lib.sign.CloudSign;
import eu.thesimplecloud.plugin.extension.LocationExtensionKt;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J;\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/module/sign/service/command/CloudSignsCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "()V", "thisService", "Leu/thesimplecloud/api/service/ICloudService;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "simplecloud-module-sign"})
@SourceDebugExtension(value={"SMAP\nCloudSignsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudSignsCommand.kt\neu/thesimplecloud/module/sign/service/command/CloudSignsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n766#2:130\n857#2,2:131\n1549#2:133\n1620#2,3:134\n*S KotlinDebug\n*F\n+ 1 CloudSignsCommand.kt\neu/thesimplecloud/module/sign/service/command/CloudSignsCommand\n*L\n123#1:130\n123#1:131,2\n124#1:133\n124#1:134,3\n*E\n"})
public final class CloudSignsCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(sender instanceof Player)) {
            return true;
        }
        Block block = ((Player)sender).getTargetBlock(null, 4);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"sender.getTargetBlock(null, 4)");
        Block block2 = block;
        if (!(block2.getState() instanceof Sign)) {
            sender.sendMessage("\u00a7cYou must look at a sign.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /cloudsigns <add/remove> [group]");
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"add")) {
            if (args.length != 2) {
                sender.sendMessage("\u00a7cUsage: /cloudsigns <add> <group>");
                return true;
            }
            String groupName = args[1];
            ICloudServiceGroup serviceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(groupName);
            if (serviceGroup == null) {
                sender.sendMessage("\u00a7cGroup not found.");
                return true;
            }
            if (serviceGroup.getServiceType() == ServiceType.PROXY) {
                sender.sendMessage("\u00a7cCannot create a sign for proxy groups.");
                return true;
            }
            SignModuleConfig signModuleConfig = SignModuleConfig.Companion.getConfig();
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
            TemplateLocation templateLocation = LocationExtensionKt.toCloudLocation((Location)location).toTemplateLocation();
            CloudSign cloudSignByLocation = signModuleConfig.getSignContainer().getCloudSignByLocation(this.thisService.getTemplate(), templateLocation);
            if (cloudSignByLocation != null) {
                sender.sendMessage("\u00a7cThere is already a sign registered on this location.");
                return true;
            }
            signModuleConfig.getSignContainer().addSign(new CloudSign(templateLocation, serviceGroup.getName()));
            signModuleConfig.update();
            sender.sendMessage("\u00a7aSign added.");
        } else if (Intrinsics.areEqual((Object)string2, (Object)"remove")) {
            SignModuleConfig signModuleConfig = SignModuleConfig.Companion.getConfig();
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
            TemplateLocation templateLocation = LocationExtensionKt.toCloudLocation((Location)location).toTemplateLocation();
            CloudSign cloudSign = signModuleConfig.getSignContainer().getCloudSignByLocation(this.thisService.getTemplate(), templateLocation);
            if (cloudSign == null) {
                sender.sendMessage("\u00a7cSign is not registered.");
                return true;
            }
            signModuleConfig.getSignContainer().removeSign(cloudSign);
            signModuleConfig.update();
            sender.sendMessage("\u00a7aSign removed.");
        } else {
            sender.sendMessage("\u00a7cUsage: /cloudsigns <add/remove> [group]");
            return true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        switch (args.length) {
            case 1: {
                Object[] objectArray = new String[]{"add", "remove"};
                list = CollectionsKt.mutableListOf((Object[])objectArray);
                break;
            }
            case 2: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ICloudServiceGroup it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getAllCachedObjects();
                boolean $i$f$filter = false;
                void var7_8 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ICloudServiceGroup)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getServiceType() != ServiceType.PROXY)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ICloudServiceGroup)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                break;
            }
            default: {
                list = new ArrayList();
            }
        }
        return list;
    }
}

