/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.module.statistics.timed.store;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.module.statistics.timed.TimedValue;
import eu.thesimplecloud.module.statistics.timed.store.ITimedValueStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Leu/thesimplecloud/module/statistics/timed/store/MongoTimedValueStore;", "T", "", "Leu/thesimplecloud/module/statistics/timed/store/ITimedValueStore;", "classOfT", "Ljava/lang/Class;", "collectionName", "", "database", "Lcom/mongodb/client/MongoDatabase;", "(Ljava/lang/Class;Ljava/lang/String;Lcom/mongodb/client/MongoDatabase;)V", "collection", "Lcom/mongodb/client/MongoCollection;", "Lorg/bson/Document;", "constructTimedValueFromDocument", "Leu/thesimplecloud/module/statistics/timed/TimedValue;", "document", "count", "", "get", "", "fromTimeStamp", "", "toTimeStamp", "getAll", "getCollectionName", "store", "", "timedValue", "simplecloud-module-statistics"})
@SourceDebugExtension(value={"SMAP\nMongoTimedValueStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoTimedValueStore.kt\neu/thesimplecloud/module/statistics/timed/store/MongoTimedValueStore\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n40#2,11:82\n1549#3:93\n1620#3,3:94\n1549#3:97\n1620#3,3:98\n*S KotlinDebug\n*F\n+ 1 MongoTimedValueStore.kt\neu/thesimplecloud/module/statistics/timed/store/MongoTimedValueStore\n*L\n47#1:82,11\n59#1:93\n59#1:94,3\n64#1:97\n64#1:98,3\n*E\n"})
public final class MongoTimedValueStore<T>
implements ITimedValueStore<T> {
    @NotNull
    private final Class<T> classOfT;
    @NotNull
    private final String collectionName;
    @NotNull
    private final MongoCollection<Document> collection;

    /*
     * WARNING - void declaration
     */
    public MongoTimedValueStore(@NotNull Class<T> classOfT, @NotNull String collectionName, @NotNull MongoDatabase database) {
        void $this$getCollection$iv;
        Intrinsics.checkNotNullParameter(classOfT, (String)"classOfT");
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.classOfT = classOfT;
        this.collectionName = collectionName;
        MongoDatabase mongoDatabase = database;
        String collectionName$iv = this.collectionName;
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, Document.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        this.collection = mongoCollection;
        Bson bson = (Bson)new BasicDBObject("timeStamp", (Object)1);
        IndexOptions indexOptions = new IndexOptions().unique(false);
        Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"IndexOptions().unique(false)");
        MongoCollectionsKt.ensureIndex(this.collection, (Bson)bson, (IndexOptions)indexOptions);
    }

    @Override
    public void store(@NotNull TimedValue<T> timedValue) {
        Intrinsics.checkNotNullParameter(timedValue, (String)"timedValue");
        Document document = (Document)JsonLib.Companion.fromObject(timedValue).getObject(Document.class);
        this.collection.insertOne((Object)document);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TimedValue<T>> getAll() {
        void $this$mapTo$iv$iv;
        FindIterable findIterable = this.collection.find();
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"collection.find()");
        Iterable $this$map$iv = KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.constructTimedValueFromDocument((Document)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TimedValue<T>> get(long fromTimeStamp, long toTimeStamp) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = KMongoIterableKt.toList((MongoIterable)((MongoIterable)MongoCollectionsKt.find(this.collection, (String)("{ timeStamp : { $gt :  " + fromTimeStamp + ", $lt : " + toTimeStamp + "}}"))));
        boolean $i$f$map = false;
        void var7_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.constructTimedValueFromDocument((Document)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String getCollectionName() {
        return this.collectionName;
    }

    private final TimedValue<T> constructTimedValueFromDocument(Document document) {
        JsonLib jsonLib = JsonLib.Companion.fromObject((Object)document);
        Object object = jsonLib.getObject("value", this.classOfT);
        Intrinsics.checkNotNull((Object)object);
        Object value = object;
        Long l = jsonLib.getLong("timeStamp");
        Intrinsics.checkNotNull((Object)l);
        long timeStamp = l;
        return new TimedValue<Object>(value, timeStamp);
    }

    @Override
    public int count() {
        return (int)this.collection.countDocuments();
    }

    @Override
    @NotNull
    public List<TimedValue<T>> get(long fromTimeStamp, long toTimeStamp, long resolution) {
        return ITimedValueStore.DefaultImpls.get(this, fromTimeStamp, toTimeStamp, resolution);
    }

    @Override
    @NotNull
    public <T extends Number> List<TimedValue<T>> getAveraged(@NotNull List<TimedValue<T>> valueList, long resolution) {
        return ITimedValueStore.DefaultImpls.getAveraged(this, valueList, resolution);
    }
}

