/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.eventapi;

import com.google.common.collect.Maps;
import eu.thesimplecloud.api.eventapi.CloudEventHandler;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventExecutor;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.eventapi.IListener;
import eu.thesimplecloud.api.eventapi.exception.EventException;
import eu.thesimplecloud.api.external.ICloudModule;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0005H\u0002J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016R\u0086\u0001\u0010\u0003\u001az\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0006 \u0007*\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0007*<\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0006 \u0007*\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Leu/thesimplecloud/api/eventapi/BasicEventManager;", "Leu/thesimplecloud/api/eventapi/IEventManager;", "()V", "listeners", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Class;", "Leu/thesimplecloud/api/eventapi/IEvent;", "kotlin.jvm.PlatformType", "", "Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent;", "addRegisteredEvent", "", "registeredEvent", "call", "event", "fromPacket", "", "getValidMethods", "", "Ljava/lang/reflect/Method;", "listenerClass", "Leu/thesimplecloud/api/eventapi/IListener;", "registerEvent", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "eventClass", "listener", "eventExecutor", "Leu/thesimplecloud/api/eventapi/IEventExecutor;", "registerListener", "removeRegisteredEvent", "unregisterAll", "unregisterAllListenersByCloudModule", "unregisterListener", "RegisteredEvent", "simplecloud-api"})
public class BasicEventManager
implements IEventManager {
    private final ConcurrentMap<Class<? extends IEvent>, List<RegisteredEvent>> listeners = Maps.newConcurrentMap();

    @Override
    public void registerListener(@NotNull ICloudModule cloudModule, @NotNull IListener listener) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        for (Method method : this.getValidMethods(listener.getClass())) {
            Class<?> eventClass;
            if (method.getParameterTypes()[0] == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out eu.thesimplecloud.api.eventapi.IEvent>");
            }
            this.addRegisteredEvent(RegisteredEvent.Companion.fromEventMethod(cloudModule, eventClass, listener, method));
        }
    }

    @Override
    public void registerEvent(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull IEventExecutor eventExecutor) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)eventExecutor, (String)"eventExecutor");
        this.addRegisteredEvent(new RegisteredEvent(cloudModule, eventClass, listener, eventExecutor));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterListener(@NotNull IListener listener) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Iterable $this$map$iv = this.listeners.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            Iterable $this$filter$iv = (Iterable)v0;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RegisteredEvent it2 = (RegisteredEvent)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getListener(), (Object)listener)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            collection.add(list2);
        }
        List list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisteredEvent it = (RegisteredEvent)element$iv;
            boolean bl = false;
            this.removeRegisteredEvent(it);
        }
    }

    @Override
    public void call(@NotNull IEvent event, boolean fromPacket) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = (List)this.listeners.get(event.getClass());
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RegisteredEvent registeredEvent = (RegisteredEvent)element$iv;
                boolean bl = false;
                registeredEvent.getEventExecutor().execute(event);
            }
        }
    }

    @Override
    public void unregisterAllListenersByCloudModule(@NotNull ICloudModule cloudModule) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Iterable $this$forEach$iv = this.listeners.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list = (List)element$iv;
            boolean bl = false;
            list.removeIf((Predicate)new Predicate<RegisteredEvent>(cloudModule){
                final /* synthetic */ ICloudModule $cloudModule$inlined;
                {
                    this.$cloudModule$inlined = iCloudModule;
                }

                public final boolean test(@NotNull RegisteredEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getCloudModule(), (Object)this.$cloudModule$inlined);
                }
            });
        }
    }

    @Override
    public void unregisterAll() {
        this.listeners.clear();
    }

    /*
     * Unable to fully structure code
     */
    private final List<Method> getValidMethods(Class<? extends IListener> listenerClass) {
        v0 = listenerClass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"listenerClass.declaredMethods");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var8_8 = $this$filterTo$iv$iv;
        var9_10 = ((void)var8_8).length;
        for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
            it = element$iv$iv = var8_8[var10_11];
            $i$a$-filter-BasicEventManager$getValidMethods$methods$1 = false;
            if (!it.isAnnotationPresent(CloudEventHandler.class)) ** GOTO lbl-1000
            v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (v1.getParameterTypes().length == 1 && IEvent.class.isAssignableFrom(it.getParameterTypes()[0])) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        methods = (List)destination$iv$iv;
        $this$forEach$iv = methods;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (Method)element$iv;
            $i$a$-forEach-BasicEventManager$getValidMethods$1 = false;
            v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            v3.setAccessible(true);
        }
        return methods;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRegisteredEvent(RegisteredEvent registeredEvent) {
        void $this$getOrPut$iv;
        ConcurrentMap<Class<? extends IEvent>, List<RegisteredEvent>> concurrentMap = this.listeners;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"this.listeners");
        ConcurrentMap<Class<? extends IEvent>, List<RegisteredEvent>> concurrentMap2 = concurrentMap;
        Class<? extends IEvent> key$iv = registeredEvent.getEventClass();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            List list = new CopyOnWriteArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List default$iv = list;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((List)object).add(registeredEvent);
    }

    private final void removeRegisteredEvent(RegisteredEvent registeredEvent) {
        block0: {
            List list = (List)this.listeners.get(registeredEvent.getEventClass());
            if (list == null) break block0;
            list.remove(registeredEvent);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent;", "", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "eventClass", "Ljava/lang/Class;", "Leu/thesimplecloud/api/eventapi/IEvent;", "listener", "Leu/thesimplecloud/api/eventapi/IListener;", "eventExecutor", "Leu/thesimplecloud/api/eventapi/IEventExecutor;", "(Leu/thesimplecloud/api/external/ICloudModule;Ljava/lang/Class;Leu/thesimplecloud/api/eventapi/IListener;Leu/thesimplecloud/api/eventapi/IEventExecutor;)V", "getCloudModule", "()Leu/thesimplecloud/api/external/ICloudModule;", "getEventClass", "()Ljava/lang/Class;", "getEventExecutor", "()Leu/thesimplecloud/api/eventapi/IEventExecutor;", "getListener", "()Leu/thesimplecloud/api/eventapi/IListener;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "simplecloud-api"})
    public static final class RegisteredEvent {
        @NotNull
        private final ICloudModule cloudModule;
        @NotNull
        private final Class<? extends IEvent> eventClass;
        @NotNull
        private final IListener listener;
        @NotNull
        private final IEventExecutor eventExecutor;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final ICloudModule getCloudModule() {
            return this.cloudModule;
        }

        @NotNull
        public final Class<? extends IEvent> getEventClass() {
            return this.eventClass;
        }

        @NotNull
        public final IListener getListener() {
            return this.listener;
        }

        @NotNull
        public final IEventExecutor getEventExecutor() {
            return this.eventExecutor;
        }

        public RegisteredEvent(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull IEventExecutor eventExecutor) {
            Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
            Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)eventExecutor, (String)"eventExecutor");
            this.cloudModule = cloudModule;
            this.eventClass = eventClass;
            this.listener = listener;
            this.eventExecutor = eventExecutor;
        }

        @NotNull
        public final ICloudModule component1() {
            return this.cloudModule;
        }

        @NotNull
        public final Class<? extends IEvent> component2() {
            return this.eventClass;
        }

        @NotNull
        public final IListener component3() {
            return this.listener;
        }

        @NotNull
        public final IEventExecutor component4() {
            return this.eventExecutor;
        }

        @NotNull
        public final RegisteredEvent copy(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull IEventExecutor eventExecutor) {
            Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
            Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)eventExecutor, (String)"eventExecutor");
            return new RegisteredEvent(cloudModule, eventClass, listener, eventExecutor);
        }

        public static /* synthetic */ RegisteredEvent copy$default(RegisteredEvent registeredEvent, ICloudModule iCloudModule, Class clazz, IListener iListener, IEventExecutor iEventExecutor, int n, Object object) {
            if ((n & 1) != 0) {
                iCloudModule = registeredEvent.cloudModule;
            }
            if ((n & 2) != 0) {
                clazz = registeredEvent.eventClass;
            }
            if ((n & 4) != 0) {
                iListener = registeredEvent.listener;
            }
            if ((n & 8) != 0) {
                iEventExecutor = registeredEvent.eventExecutor;
            }
            return registeredEvent.copy(iCloudModule, clazz, iListener, iEventExecutor);
        }

        @NotNull
        public String toString() {
            return "RegisteredEvent(cloudModule=" + this.cloudModule + ", eventClass=" + this.eventClass + ", listener=" + this.listener + ", eventExecutor=" + this.eventExecutor + ")";
        }

        public int hashCode() {
            ICloudModule iCloudModule = this.cloudModule;
            Class<? extends IEvent> clazz = this.eventClass;
            IListener iListener = this.listener;
            IEventExecutor iEventExecutor = this.eventExecutor;
            return (((iCloudModule != null ? iCloudModule.hashCode() : 0) * 31 + (clazz != null ? clazz.hashCode() : 0)) * 31 + (iListener != null ? iListener.hashCode() : 0)) * 31 + (iEventExecutor != null ? iEventExecutor.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RegisteredEvent)) break block3;
                    RegisteredEvent registeredEvent = (RegisteredEvent)object;
                    if (!Intrinsics.areEqual((Object)this.cloudModule, (Object)registeredEvent.cloudModule) || !Intrinsics.areEqual(this.eventClass, registeredEvent.eventClass) || !Intrinsics.areEqual((Object)this.listener, (Object)registeredEvent.listener) || !Intrinsics.areEqual((Object)this.eventExecutor, (Object)registeredEvent.eventExecutor)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent$Companion;", "", "()V", "fromEventMethod", "Leu/thesimplecloud/api/eventapi/BasicEventManager$RegisteredEvent;", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "eventClass", "Ljava/lang/Class;", "Leu/thesimplecloud/api/eventapi/IEvent;", "listener", "Leu/thesimplecloud/api/eventapi/IListener;", "method", "Ljava/lang/reflect/Method;", "simplecloud-api"})
        public static final class Companion {
            @NotNull
            public final RegisteredEvent fromEventMethod(@NotNull ICloudModule cloudModule, @NotNull Class<? extends IEvent> eventClass, @NotNull IListener listener, @NotNull Method method) {
                Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
                Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                return new RegisteredEvent(cloudModule, eventClass, listener, new IEventExecutor(eventClass, method, listener){
                    final /* synthetic */ Class $eventClass;
                    final /* synthetic */ Method $method;
                    final /* synthetic */ IListener $listener;

                    public void execute(@NotNull IEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (!this.$eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        try {
                            this.$method.invoke((Object)this.$listener, event);
                        }
                        catch (Exception ex) {
                            throw (Throwable)new EventException(event, (Throwable)ex);
                        }
                    }
                    {
                        this.$eventClass = $captured_local_variable$0;
                        this.$method = $captured_local_variable$1;
                        this.$listener = $captured_local_variable$2;
                    }
                });
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

