/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.language;

import com.google.common.collect.Maps;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.language.ILanguageManager;
import eu.thesimplecloud.api.language.LanguageProperty;
import eu.thesimplecloud.api.language.LoadedLanguageFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0011\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Leu/thesimplecloud/api/language/LanguageManager;", "Leu/thesimplecloud/api/language/ILanguageManager;", "()V", "languageFiles", "Ljava/util/concurrent/ConcurrentMap;", "Leu/thesimplecloud/api/external/ICloudModule;", "kotlin.jvm.PlatformType", "Leu/thesimplecloud/api/language/LoadedLanguageFile;", "clearAll", "", "getAllProperties", "", "Leu/thesimplecloud/api/language/LanguageProperty;", "getMessage", "", "property", "placeholderValues", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "registerLanguageFile", "cloudModule", "languageFile", "unregisterLanguageFileByCloudModule", "simplecloud-api"})
public class LanguageManager
implements ILanguageManager {
    private final ConcurrentMap<ICloudModule, LoadedLanguageFile> languageFiles = Maps.newConcurrentMap();

    @Override
    public void registerLanguageFile(@NotNull ICloudModule cloudModule, @NotNull LoadedLanguageFile languageFile) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Intrinsics.checkNotNullParameter((Object)languageFile, (String)"languageFile");
        ConcurrentMap<ICloudModule, LoadedLanguageFile> concurrentMap = this.languageFiles;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"this.languageFiles");
        ((Map)concurrentMap).put(cloudModule, languageFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getMessage(@NotNull String property, String ... placeholderValues) {
        Object v0;
        block3: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)placeholderValues, (String)"placeholderValues");
            Iterable $this$map$iv = this.languageFiles.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LoadedLanguageFile loadedLanguageFile = (LoadedLanguageFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List<LanguageProperty> list = it.getProperties();
                collection.add(list);
            }
            List allProperties = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            Iterable $this$firstOrNull$iv = allProperties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LanguageProperty it = (LanguageProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProperty(), (Object)property)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        LanguageProperty languageProperty = v0;
        if (languageProperty == null) {
            return property;
        }
        LanguageProperty languageProperty2 = languageProperty;
        return languageProperty2.getReplacedMessage(Arrays.copyOf(placeholderValues, placeholderValues.length));
    }

    @Override
    public void unregisterLanguageFileByCloudModule(@NotNull ICloudModule cloudModule) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        this.languageFiles.remove(cloudModule);
    }

    @Override
    public void clearAll() {
        this.languageFiles.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LanguageProperty> getAllProperties() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.languageFiles.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoadedLanguageFile loadedLanguageFile = (LoadedLanguageFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<LanguageProperty> list = it.getProperties();
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }
}

